/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.bit;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.common.util.DateUtils;
import java.util.Date;
import java.util.Objects;

public class HorseBit
implements RepositoryEntity<Integer> {
    private final int id;
    private final String name;
    private final String identifier;
    private final String description;
    private final int durationDays;
    private final double controlPercentage;
    private final double steeringPercentage;

    public HorseBit(int id, String name, String identifier, String description, int durationDays, double controlPercentage, double steeringPercentage) {
        this.id = id;
        this.name = name;
        this.identifier = identifier;
        this.description = description;
        this.durationDays = durationDays;
        this.controlPercentage = controlPercentage;
        this.steeringPercentage = steeringPercentage;
    }

    @Override
    public Integer getKey() {
        return this.getId();
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getDescription() {
        return this.description;
    }

    public int getDurationDays() {
        return this.durationDays;
    }

    public Date getMaximumEndTimeFromNow() {
        return DateUtils.futureDaysOffset(this.getDurationDays());
    }

    public double getControlPercentage() {
        return this.controlPercentage;
    }

    public double getSteeringPercentage() {
        return this.steeringPercentage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HorseBit horseBit = (HorseBit)o;
        return this.id == horseBit.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.name;
    }
}

