/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.bit;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.bit.HorseBit;
import java.util.List;

public class HorseBitDatabase
implements RepositoryDatasource<HorseBit, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_NAME = "NAME";
    private static final String COLUMN_IDENTIFIER = "IDENTIFIER";
    private static final String COLUMN_DESCRIPTION = "DESCRIPTION";
    private static final String COLUMN_DURATION_DAYS = "DURATION_DAYS";
    private static final String COLUMN_CONTROL_PERCENTAGE = "CONTROL_PERCENTAGE";
    private static final String COLUMN_STEERING_PERCENTAGE = "STEERING_PERCENTAGE";

    @Override
    public List<HorseBit> retrieveAll() {
        return Query.selectAllFrom("HORSE_BIT").getList(this::getFromResultRow);
    }

    private HorseBit getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        String name = row.getString(COLUMN_NAME);
        String identifier = row.getString(COLUMN_IDENTIFIER);
        String description = row.getString(COLUMN_DESCRIPTION);
        int durationDays = row.getInt(COLUMN_DURATION_DAYS);
        double controlPercentage = row.getDouble(COLUMN_CONTROL_PERCENTAGE);
        double steeringPercentage = row.getDouble(COLUMN_STEERING_PERCENTAGE);
        return new HorseBit(id, name, identifier, description, durationDays, controlPercentage, steeringPercentage);
    }
}

