/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.blockedphrase;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.blockedphrase.BlockedPhrase;
import com.equestricraft.core.blockedphrase.BlockedPhraseException;
import com.equestricraft.core.blockedphrase.BlockedPhraseRepository;
import com.equestricraft.core.blockedphrase.BlockedPhraseService;
import java.util.List;

public class BlockedPhraseServiceImpl
implements BlockedPhraseService {
    @Service
    private BlockedPhraseRepository blockedPhraseRepository;

    @Override
    public void ensureNoBlockedPhrases(String text) throws BlockedPhraseException {
        if (this.containsBlockedPhrase(text)) {
            throw new BlockedPhraseException();
        }
    }

    @Override
    public boolean containsBlockedPhrase(String text) {
        text = text.trim().toLowerCase();
        List<String> blockedPhrases = this.getBlockedPhrases();
        for (String phrase : blockedPhrases) {
            if (!text.contains(phrase)) continue;
            return true;
        }
        return false;
    }

    private List<String> getBlockedPhrases() {
        return this.blockedPhraseRepository.streamAll().map(BlockedPhrase::getText).map(String::trim).map(String::toLowerCase).toList();
    }
}

