/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.blood.age;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.blood.age.BloodAgeSetting;
import java.util.List;

public class BloodAgeSettingDatabase
implements RepositoryDatasource<BloodAgeSetting, Integer> {
    @Override
    public List<BloodAgeSetting> retrieveAll() {
        return Query.selectAllFrom("BLOOD_AGE_SETTING").getList(this::getFromResultRow);
    }

    private BloodAgeSetting getFromResultRow(ResultRow row) {
        int ageMonths = row.getInt("AGE_MONTHS");
        int redBloodCellValue = row.getInt("RED_BLOOD_CELL_VALUE");
        int whiteBloodCellValue = row.getInt("WHITE_BLOOD_CELL_VALUE");
        int plateletsValue = row.getInt("PLATELETS_VALUE");
        int electrolytesValue = row.getInt("ELECTROLYTES_VALUE");
        int enzymesValue = row.getInt("ENZYMES_VALUE");
        int proteinValue = row.getInt("PROTEIN_VALUE");
        int oxygenValue = row.getInt("OXYGEN_VALUE");
        int carbonDioxideValue = row.getInt("CARBON_DIOXIDE_VALUE");
        int nitrogenValue = row.getInt("NITROGEN_VALUE");
        return new BloodAgeSetting(ageMonths, redBloodCellValue, whiteBloodCellValue, plateletsValue, electrolytesValue, enzymesValue, proteinValue, oxygenValue, carbonDioxideValue, nitrogenValue);
    }
}

