/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.breed;

import com.equestricraft.api.common.APIBreedDto;
import com.equestricraft.api.common.APIBreedsDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.MapAdapter;
import com.equestricraft.core.breed.Breed;
import com.equestricraft.core.breed.BreedRepository;
import com.equestricraft.core.breed.BreedTransformer;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;

public class APIBreedsDtoImpl
extends MapAdapter<String, APIBreedDto>
implements APIBreedsDto {
    @Service
    private static BreedRepository breedRepository;
    @Service
    private static BreedTransformer breedTransformer;

    @Override
    public int size() {
        return breedRepository.getTotalSize();
    }

    @Override
    public APIBreedDto get(Object key) {
        Optional<Breed> breed = this.findByKey(key);
        return breed.map(breedTransformer::toDto).orElse(null);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.findByKey(key).isPresent();
    }

    private Optional<Breed> findByKey(Object key) {
        if (key instanceof String) {
            String identifier = (String)key;
            return breedRepository.findByIdentifier(identifier);
        }
        if (key instanceof Integer) {
            Integer id = (Integer)key;
            return breedRepository.findByKeyIfExists(id);
        }
        throw new IllegalArgumentException("Invalid key provided");
    }

    @Override
    public Set<Map.Entry<String, APIBreedDto>> entrySet() {
        return new EntrySet();
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<String, APIBreedDto>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<String, APIBreedDto>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return APIBreedsDtoImpl.this.size();
        }

        static final class EntrySetIterator
        implements Iterator<Map.Entry<String, APIBreedDto>> {
            private final Iterator<Breed> breedIterator = breedRepository.findAll().iterator();

            EntrySetIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.breedIterator.hasNext();
            }

            @Override
            public Map.Entry<String, APIBreedDto> next() {
                if (this.hasNext()) {
                    Breed breed = this.breedIterator.next();
                    APIBreedDto dto = breedTransformer.toDto(breed);
                    return Map.entry(breed.getIdentifier(), dto);
                }
                throw new NoSuchElementException();
            }
        }
    }
}

