/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.breed;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.common.BreedCoatPolicy;
import com.equestricraft.core.breed.BreedColor;
import com.equestricraft.core.breed.BreedConformationRating;
import com.equestricraft.core.breed.BreedMarking;
import com.equestricraft.core.breed.BreedMarkingGroup;
import java.util.List;
import java.util.Objects;

public class Breed
implements RepositoryEntity<Integer> {
    private final int id;
    private final String name;
    private final String identifier;
    private final String description;
    private final BreedCoatPolicy grayPolicy;
    private final List<BreedColor> colors;
    private final List<BreedMarking> markings;
    private final List<BreedMarkingGroup> markingGroups;
    private final String conditionScript;
    private final double minimumHeight;
    private final double maximumHeight;
    private final List<BreedConformationRating> conformationRatings;
    private final boolean availableForCustomHorses;
    private final double stallionMinimumWeight;
    private final double stallionMaximumWeight;
    private final double mareMinimumWeight;
    private final double mareMaximumWeight;

    public Breed(int id, String name, String identifier, String description, BreedCoatPolicy grayPolicy, List<BreedColor> colors, List<BreedMarking> markings, List<BreedMarkingGroup> markingGroups, String conditionScript, double minimumHeight, double maximumHeight, List<BreedConformationRating> conformationRatings, boolean availableForCustomHorses, double stallionMinimumWeight, double stallionMaximumWeight, double mareMinimumWeight, double mareMaximumWeight) {
        this.id = id;
        this.name = name;
        this.identifier = identifier;
        this.description = description;
        this.grayPolicy = grayPolicy;
        this.colors = colors;
        this.markings = markings;
        this.markingGroups = markingGroups;
        this.conditionScript = conditionScript;
        this.minimumHeight = minimumHeight;
        this.maximumHeight = maximumHeight;
        this.conformationRatings = conformationRatings;
        this.availableForCustomHorses = availableForCustomHorses;
        this.stallionMinimumWeight = stallionMinimumWeight;
        this.stallionMaximumWeight = stallionMaximumWeight;
        this.mareMinimumWeight = mareMinimumWeight;
        this.mareMaximumWeight = mareMaximumWeight;
    }

    @Override
    public Integer getKey() {
        return this.getId();
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getDescription() {
        return this.description;
    }

    public BreedCoatPolicy getGrayPolicy() {
        return this.grayPolicy;
    }

    public List<BreedColor> getColors() {
        return this.colors;
    }

    public List<BreedMarking> getMarkings() {
        return this.markings;
    }

    public List<BreedMarkingGroup> getMarkingGroups() {
        return this.markingGroups;
    }

    public String getConditionScript() {
        return this.conditionScript;
    }

    public double getMinimumHeight() {
        return this.minimumHeight;
    }

    public double getMaximumHeight() {
        return this.maximumHeight;
    }

    public List<BreedConformationRating> getConformationRatings() {
        return this.conformationRatings;
    }

    public boolean isAvailableForCustomHorses() {
        return this.availableForCustomHorses;
    }

    public double getStallionMinimumWeight() {
        return this.stallionMinimumWeight;
    }

    public double getStallionMaximumWeight() {
        return this.stallionMaximumWeight;
    }

    public double getMareMinimumWeight() {
        return this.mareMinimumWeight;
    }

    public double getMareMaximumWeight() {
        return this.mareMaximumWeight;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Breed breed = (Breed)o;
        return this.id == breed.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.name;
    }
}

