/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.breed;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.common.BreedCoatPolicy;
import com.equestricraft.common.ConformationCheckType;
import com.equestricraft.common.HorseCoatColor;
import com.equestricraft.common.HorseCoatMarking;
import com.equestricraft.core.breed.Breed;
import com.equestricraft.core.breed.BreedColor;
import com.equestricraft.core.breed.BreedConformationRating;
import com.equestricraft.core.breed.BreedMarking;
import com.equestricraft.core.breed.BreedMarkingGroup;
import java.util.List;

public class BreedDatabase
implements RepositoryDatasource<Breed, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_NAME = "NAME";
    private static final String COLUMN_IDENTIFIER = "IDENTIFIER";
    private static final String COLUMN_DESCRIPTION = "DESCRIPTION";
    private static final String COLUMN_GRAY_POLICY = "GRAY_POLICY";
    private static final String COLUMN_CONDITION_SCRIPT = "CONDITION_SCRIPT";
    private static final String COLUMN_MINIMUM_BASE_HEIGHT = "MINIMUM_BASE_HEIGHT";
    private static final String COLUMN_MAXIMUM_BASE_HEIGHT = "MAXIMUM_BASE_HEIGHT";
    private static final String COLUMN_AVAILABLE_FOR_CUSTOM_HORSES = "AVAILABLE_FOR_CUSTOM_HORSES";
    private static final String COLUMN_STALLION_MINIMUM_WEIGHT = "STALLION_MINIMUM_WEIGHT";
    private static final String COLUMN_STALLION_MAXIMUM_WEIGHT = "STALLION_MAXIMUM_WEIGHT";
    private static final String COLUMN_MARE_MINIMUM_WEIGHT = "MARE_MINIMUM_WEIGHT";
    private static final String COLUMN_MARE_MAXIMUM_WEIGHT = "MARE_MAXIMUM_WEIGHT";
    private static final String COLUMN_PUBLISHED = "PUBLISHED";
    private static final String COLUMN_BREED_ID = "BREED_ID";
    private static final String COLUMN_COLOR = "COLOR";
    private static final String COLUMN_MARKING = "MARKING";
    private static final String COLUMN_MARKING_GROUP = "MARKING_GROUP";
    private static final String COLUMN_POLICY = "POLICY";
    private static final String COLUMN_CHECK_TYPE = "CHECK_TYPE";
    private static final String COLUMN_VERY_GOOD_THRESHOLD = "VERY_GOOD_THRESHOLD";
    private static final String COLUMN_GOOD_THRESHOLD = "GOOD_THRESHOLD";
    private static final String COLUMN_OK_THRESHOLD = "OK_THRESHOLD";
    private static final String COLUMN_POOR_THRESHOLD = "POOR_THRESHOLD";

    @Override
    public List<Breed> retrieveAll() {
        return Query.selectAllFrom("BREED").where(QueryColumn.column(COLUMN_PUBLISHED, true)).getList(this::getBreedFromResultRow);
    }

    private Breed getBreedFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        String name = row.getString(COLUMN_NAME);
        String identifier = row.getString(COLUMN_IDENTIFIER);
        String description = row.getString(COLUMN_DESCRIPTION);
        BreedCoatPolicy grayPolicy = row.getEnum(COLUMN_GRAY_POLICY, BreedCoatPolicy.class);
        List<BreedColor> colors = this.getColorsForBreed(id);
        List<BreedMarking> markings = this.getMarkingsForBreed(id);
        List<BreedMarkingGroup> markingGroups = this.getMarkingGroupsForBreed(id);
        String conditionScript = row.getString(COLUMN_CONDITION_SCRIPT);
        double minimumHeight = row.getDouble(COLUMN_MINIMUM_BASE_HEIGHT);
        double maximumHeight = row.getDouble(COLUMN_MAXIMUM_BASE_HEIGHT);
        List<BreedConformationRating> conformationRatings = this.getConformationRatingsForBreed(id);
        boolean availableForCustomHorses = row.getBoolean(COLUMN_AVAILABLE_FOR_CUSTOM_HORSES);
        double stallionMinimumWeight = row.getDouble(COLUMN_STALLION_MINIMUM_WEIGHT);
        double stallionMaximumWeight = row.getDouble(COLUMN_STALLION_MAXIMUM_WEIGHT);
        double mareMinimumWeight = row.getDouble(COLUMN_MARE_MINIMUM_WEIGHT);
        double mareMaximumWeight = row.getDouble(COLUMN_MARE_MAXIMUM_WEIGHT);
        return new Breed(id, name, identifier, description, grayPolicy, colors, markings, markingGroups, conditionScript, minimumHeight, maximumHeight, conformationRatings, availableForCustomHorses, stallionMinimumWeight, stallionMaximumWeight, mareMinimumWeight, mareMaximumWeight);
    }

    private List<BreedColor> getColorsForBreed(int breedId) {
        return Query.selectAllFrom("BREED_COLOR").where(QueryColumn.column(COLUMN_BREED_ID, breedId)).getList(this::getColorFromResultRow);
    }

    private BreedColor getColorFromResultRow(ResultRow row) {
        HorseCoatColor color = row.getEnum(COLUMN_COLOR, HorseCoatColor.class);
        BreedCoatPolicy policy = row.getEnum(COLUMN_POLICY, BreedCoatPolicy.class);
        return new BreedColor(color, policy);
    }

    private List<BreedMarking> getMarkingsForBreed(int breedId) {
        return Query.selectAllFrom("BREED_MARKING").where(QueryColumn.column(COLUMN_BREED_ID, breedId)).getList(this::getMarkingFromResultRow);
    }

    private BreedMarking getMarkingFromResultRow(ResultRow row) {
        HorseCoatMarking marking = row.getEnum(COLUMN_MARKING, HorseCoatMarking.class);
        BreedCoatPolicy policy = row.getEnum(COLUMN_POLICY, BreedCoatPolicy.class);
        return new BreedMarking(marking, policy);
    }

    private List<BreedMarkingGroup> getMarkingGroupsForBreed(int breedId) {
        return Query.selectAllFrom("BREED_MARKING_GROUP").where(QueryColumn.column(COLUMN_BREED_ID, breedId)).getList(this::getMarkingGroupFromResultRow);
    }

    private BreedMarkingGroup getMarkingGroupFromResultRow(ResultRow row) {
        HorseCoatMarking.MarkingGroup group = row.getEnum(COLUMN_MARKING_GROUP, HorseCoatMarking.MarkingGroup.class);
        BreedCoatPolicy policy = row.getEnum(COLUMN_POLICY, BreedCoatPolicy.class);
        return new BreedMarkingGroup(group, policy);
    }

    private List<BreedConformationRating> getConformationRatingsForBreed(int breedId) {
        return Query.selectAllFrom("BREED_CONFORMATION_RATING").where(QueryColumn.column(COLUMN_BREED_ID, breedId)).getList(this::getConformationRatingFromResultSet);
    }

    private BreedConformationRating getConformationRatingFromResultSet(ResultRow row) {
        ConformationCheckType check2 = row.getEnum(COLUMN_CHECK_TYPE, ConformationCheckType.class);
        double veryGoodThreshold = row.getDouble(COLUMN_VERY_GOOD_THRESHOLD);
        double goodThreshold = row.getDouble(COLUMN_GOOD_THRESHOLD);
        double okThreshold = row.getDouble(COLUMN_OK_THRESHOLD);
        double poorThreshold = row.getDouble(COLUMN_POOR_THRESHOLD);
        return new BreedConformationRating(check2, veryGoodThreshold, goodThreshold, okThreshold, poorThreshold);
    }
}

