/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.bulletin;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.base.repository.RepositorySearchQuery;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.bulletin.Bulletin;
import com.equestricraft.core.bulletin.BulletinDatabase;
import java.util.List;
import java.util.Optional;

public class BulletinRepository
extends Repository<Bulletin, Integer> {
    @Service
    private BulletinDatabase bulletinDatabase;

    @Override
    protected RepositoryDatasource<Bulletin, Integer> getDatasource() {
        return this.bulletinDatabase;
    }

    public List<Bulletin> findOrderedPublishedBulletins() {
        long timeNow = System.currentTimeMillis();
        RepositorySearchQuery<Bulletin> searchQuery = this.createSearchQuery();
        searchQuery.filter(b -> b.getPublishTime() != null && b.getPublishTime() <= timeNow);
        searchQuery.sort(Bulletin::getPublishTime);
        return searchQuery.many();
    }

    public Optional<Bulletin> findMostRecentPublishedBulletin() {
        long timeNow = System.currentTimeMillis();
        RepositorySearchQuery<Bulletin> searchQuery = this.createSearchQuery();
        searchQuery.filter(b -> b.getPublishTime() != null && b.getPublishTime() <= timeNow);
        searchQuery.sortReverse(Bulletin::getPublishTime);
        return searchQuery.single();
    }
}

