/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.bulletin;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.bulletin.Bulletin;
import com.equestricraft.core.bulletin.BulletinInfo;
import com.equestricraft.core.bulletin.BulletinRepository;
import com.equestricraft.core.bulletin.BulletinSession;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.bulletin.BulletinPlayerSession;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public class BulletinSessionImpl
implements BulletinSession {
    @Service
    private BulletinRepository bulletinRepository;
    @Service
    private BulletinPlayerSession bulletinPlayerSession;

    @Override
    public Optional<BulletinInfo> getBulletinToShowForPlayer(ECPlayer player) {
        List<Bulletin> publishedBulletins = this.bulletinRepository.findOrderedPublishedBulletins();
        List<Integer> bulletinsPlayerHasSeen = this.bulletinPlayerSession.retrieveIdsOfBulletinsPlayerHasSeen(player);
        List<Bulletin> bulletinsToShow = publishedBulletins.stream().filter(Predicate.not(b -> bulletinsPlayerHasSeen.contains(b.getId()))).toList();
        if (bulletinsToShow.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.buildInfo(bulletinsToShow.get(0)));
    }

    @Override
    public Optional<BulletinInfo> getMostRecentBulletin() {
        Optional<Bulletin> bulletin = this.bulletinRepository.findMostRecentPublishedBulletin();
        return bulletin.map(this::buildInfo);
    }

    private BulletinInfo buildInfo(Bulletin bulletin) {
        return new BulletinInfo(bulletin.getId(), bulletin.getTitle(), bulletin.getText());
    }
}

