/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.business;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.common.BusinessOwnershipType;
import com.equestricraft.core.business.Business;
import java.sql.Date;
import java.util.List;

public class BusinessDatabase
implements RepositoryDatasource<Business, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_NAME = "NAME";
    private static final String COLUMN_OWNER_ID = "OWNER_ID";
    private static final String COLUMN_OWNERSHIP_TYPE = "OWNERSHIP_TYPE";
    private static final String COLUMN_INCORPORATION_DATE = "INCORPORATION_DATE";
    private static final String COLUMN_LAST_INSPECTION = "LAST_INSPECTION";
    private static final String COLUMN_INSPECTION_DUE = "INSPECTION_DUE";
    private static final String COLUMN_ACTIVE = "ACTIVE";
    private static final String COLUMN_BANK_ACCOUNT_ID = "BANK_ACCOUNT_ID";
    private static final String COLUMN_NEXT_INVOICE_NUMBER = "NEXT_INVOICE_NUMBER";
    private static final String COLUMN_BUSINESS_ID = "BUSINESS_ID";
    private static final String COLUMN_CATEGORY_ID = "CATEGORY_ID";

    @Override
    public void create(Business business) {
        Query.insertInto("BUSINESS").columns(QueryColumn.column(COLUMN_NAME, business.getName()), QueryColumn.column(COLUMN_OWNER_ID, business.getOwnerId()), QueryColumn.column(COLUMN_OWNERSHIP_TYPE, business.getOwnershipType()), QueryColumn.column(COLUMN_INCORPORATION_DATE, business.getIncorporationDate()), QueryColumn.column(COLUMN_LAST_INSPECTION, business.getLastInspection()), QueryColumn.column(COLUMN_INSPECTION_DUE, business.getInspectionDue()), QueryColumn.column(COLUMN_ACTIVE, business.isActive()), QueryColumn.column(COLUMN_BANK_ACCOUNT_ID, business.getBankAccountId())).executeGetGeneratedKey(business::setId);
        for (Integer categoryId : business.getCategoryIds()) {
            Query.insertInto("BUSINESS_CATEGORY_BUSINESS").columns(QueryColumn.column(COLUMN_BUSINESS_ID, business.getId()), QueryColumn.column(COLUMN_CATEGORY_ID, categoryId)).execute();
        }
    }

    @Override
    public List<Business> retrieveAll() {
        return Query.selectAllFrom("BUSINESS").getList(this::getBusinessFromResultRow);
    }

    private Business getBusinessFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        String name = row.getString(COLUMN_NAME);
        int ownerId = row.getInt(COLUMN_OWNER_ID);
        BusinessOwnershipType ownershipType = row.getEnum(COLUMN_OWNERSHIP_TYPE, BusinessOwnershipType.class);
        Date incorporationDate = row.getNullableDate(COLUMN_INCORPORATION_DATE);
        Date lastInspection = row.getNullableDate(COLUMN_LAST_INSPECTION);
        Date inspectionDue = row.getNullableDate(COLUMN_INSPECTION_DUE);
        boolean active = row.getBoolean(COLUMN_ACTIVE);
        Integer bankAccountId = row.getNullableInt(COLUMN_BANK_ACCOUNT_ID);
        int nextInvoiceNumber = row.getInt(COLUMN_NEXT_INVOICE_NUMBER);
        List<Integer> categoryIds = this.retrieveCategoryIdsForBusiness(id);
        return new Business(id, name, ownerId, ownershipType, incorporationDate, lastInspection, inspectionDue, active, bankAccountId, nextInvoiceNumber, categoryIds);
    }

    private List<Integer> retrieveCategoryIdsForBusiness(int businessId) {
        return Query.selectAllFrom("BUSINESS_CATEGORY_BUSINESS").where(QueryColumn.column(COLUMN_BUSINESS_ID, businessId)).getList(row -> row.getInt(COLUMN_CATEGORY_ID));
    }

    @Override
    public void update(Business business) {
        Query.update("BUSINESS").set(QueryColumn.column(COLUMN_LAST_INSPECTION, business.getLastInspection()), QueryColumn.column(COLUMN_INSPECTION_DUE, business.getInspectionDue()), QueryColumn.column(COLUMN_BANK_ACCOUNT_ID, business.getBankAccountId()), QueryColumn.column(COLUMN_OWNER_ID, business.getOwnerId()), QueryColumn.column(COLUMN_NEXT_INVOICE_NUMBER, business.getNextInvoiceNumber())).where(QueryColumn.column(COLUMN_ID, business.getId())).execute();
    }
}

