/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.business;

import com.equestricraft.base.pagination.Pagination;
import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.business.Business;
import com.equestricraft.core.business.BusinessPublicRegisterPage;
import com.equestricraft.core.business.BusinessPublicRegisterPageSession;
import com.equestricraft.core.business.BusinessPublicRegisterSession;
import com.equestricraft.core.business.BusinessRegisterItem;
import com.equestricraft.core.business.BusinessRepository;
import java.util.Comparator;
import java.util.List;

public class BusinessPublicRegisterPageSessionImpl
extends Pagination<BusinessRegisterItem, BusinessPublicRegisterPage, Object, String>
implements BusinessPublicRegisterPageSession {
    @Service
    private BusinessRepository businessRepository;
    @Service
    private BusinessPublicRegisterSession businessPublicRegisterSession;

    @Override
    public BusinessPublicRegisterPage retrievePage(int pageNumber, String searchTerms) {
        List<Business> businesses = this.businessRepository.findActiveBusinesses();
        List<BusinessRegisterItem> items = businesses.stream().map(this.businessPublicRegisterSession::buildRegisterItemForBusiness).toList();
        return (BusinessPublicRegisterPage)this.paginate(items, pageNumber, SortDirection.ASCENDING, null, searchTerms);
    }

    @Override
    protected int getMaximumPerPage() {
        return 10;
    }

    @Override
    protected boolean filter(BusinessRegisterItem item, String filterObject) {
        if (filterObject == null) {
            return true;
        }
        filterObject = filterObject.toLowerCase();
        return item.name().toLowerCase().contains(filterObject);
    }

    @Override
    protected Comparator<BusinessRegisterItem> compare(Object sortOrderObject) {
        return Comparator.comparing(BusinessRegisterItem::name);
    }

    @Override
    protected BusinessPublicRegisterPage buildPage(List<BusinessRegisterItem> items, int pageNumber, int totalPages, SortDirection sortDirection, Object sortObject, String filterObject) {
        return new BusinessPublicRegisterPage(items, pageNumber, totalPages, sortDirection, sortObject, filterObject);
    }
}

