/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.business;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.business.Business;
import com.equestricraft.core.business.BusinessInspectionItem;
import com.equestricraft.core.business.BusinessPublicRegisterSession;
import com.equestricraft.core.business.BusinessRegisterItem;
import com.equestricraft.core.business.InspectionStatus;
import com.equestricraft.core.business.category.BusinessCategoryRepository;
import com.equestricraft.core.business.inspection.BusinessInspection;
import com.equestricraft.core.business.inspection.BusinessInspectionRepository;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.core.player.PlayerTransformer;
import java.util.List;

public class BusinessPublicRegisterSessionImpl
implements BusinessPublicRegisterSession {
    @Service
    private BusinessInspectionRepository businessInspectionRepository;
    @Service
    private BusinessCategoryRepository businessCategoryRepository;
    @Service
    private PlayerRepository playerRepository;
    @Service
    private PlayerTransformer playerTransformer;

    @Override
    public BusinessRegisterItem buildRegisterItemForBusiness(Business business) {
        int daysActive = DateUtils.daysSince(business.getIncorporationDate());
        CorePlayer owner = (CorePlayer)this.playerRepository.findByKey(business.getOwnerId());
        InspectionStatus inspectionStatus = this.determineInspectionStatusForBusiness(business);
        List categories = this.businessCategoryRepository.findByKeys(business.getCategoryIds());
        List<BusinessRegisterItem.BusinessRegisterItemCategory> categoryItems = categories.stream().map(c -> new BusinessRegisterItem.BusinessRegisterItemCategory(c.getId(), c.getName())).toList();
        return new BusinessRegisterItem(business.getId(), business.getName(), daysActive, this.playerTransformer.toSimple(owner), inspectionStatus, categoryItems);
    }

    private InspectionStatus determineInspectionStatusForBusiness(Business business) {
        return this.businessInspectionRepository.findMostRecentInspectionByBusinessId(business.getId()).map(this::getInspectionStatus).orElse(InspectionStatus.OVERDUE);
    }

    private InspectionStatus getInspectionStatus(BusinessInspection mostRecentInspection) {
        if (mostRecentInspection.isPassed()) {
            if (DateUtils.isInPast(mostRecentInspection.getTimeStamp())) {
                return InspectionStatus.OVERDUE;
            }
            return InspectionStatus.PASSED;
        }
        return InspectionStatus.FAILED;
    }

    @Override
    public List<BusinessInspectionItem> retrieveBusinessInspectionDetails(int businessId) {
        List<BusinessInspection> inspections = this.businessInspectionRepository.findOrderedInspectionsByBusinessId(businessId);
        return this.buildInspectionItemList(inspections);
    }

    private List<BusinessInspectionItem> buildInspectionItemList(List<BusinessInspection> businessInspections) {
        return businessInspections.stream().map(this::buildInspectionItem).toList();
    }

    private BusinessInspectionItem buildInspectionItem(BusinessInspection businessInspection) {
        int daysSince = DateUtils.daysSince(businessInspection.getTimeStamp());
        return new BusinessInspectionItem(businessInspection.getId(), daysSince, businessInspection.isPassed(), businessInspection.getNotes());
    }
}

