/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.business;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.base.repository.RepositorySearchQuery;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.business.Business;
import com.equestricraft.core.business.BusinessDatabase;
import java.util.List;

public class BusinessRepository
extends Repository<Business, Integer> {
    @Service
    private BusinessDatabase businessDatabase;

    @Override
    protected RepositoryDatasource<Business, Integer> getDatasource() {
        return this.businessDatabase;
    }

    public List<Business> findActiveBusinesses() {
        return this.findListByPredicates(Business::isActive);
    }

    public List<Business> findActiveBusinessesByPlayer(int playerId) {
        RepositorySearchQuery<Business> query = this.createSearchQuery();
        query.filter(Business::isActive);
        query.filter(b -> b.getOwnerId() == playerId);
        return query.many();
    }
}

