/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.business;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.BusinessOwnershipType;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.business.Business;
import com.equestricraft.core.business.BusinessListItem;
import com.equestricraft.core.business.BusinessRepository;
import com.equestricraft.core.business.BusinessSession;
import com.equestricraft.core.business.category.BusinessCategory;
import com.equestricraft.core.business.category.BusinessCategoryRepository;
import com.equestricraft.core.economy.account.BankAccount;
import com.equestricraft.core.economy.account.BankAccountSession;
import com.equestricraft.core.economy.account.CannotUpdateAccountException;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.core.player.PlayerTransformer;
import com.equestricraft.logging.Log;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class BusinessSessionImpl
implements BusinessSession {
    @Service
    private BusinessCategoryRepository businessCategoryRepository;
    @Service
    private BusinessRepository businessRepository;
    @Service
    private PlayerRepository playerRepository;
    @Service
    private BankAccountSession bankAccountSession;
    @Service
    private PlayerTransformer playerTransformer;
    private static final Log log = Log.getLogger(BusinessSessionImpl.class.getName());

    @Override
    public Date calculateEarliestInspectionDateFromNow(List<Integer> categoryIds) {
        List categories = this.businessCategoryRepository.findByKeys(categoryIds);
        Integer minimumDaysUntilNext = categories.stream().map(BusinessCategory::getInspectionPeriodDays).min(Comparator.comparingInt(d -> d)).orElseThrow();
        return DateUtils.futureDaysOffset(minimumDaysUntilNext);
    }

    @Override
    public void transferBusiness(Business business, ECPlayer newOwner) {
        business.setOwnerId(newOwner.getId());
        business.save();
        this.transferBusinessBankAccount(business, newOwner);
    }

    @Override
    public List<BusinessListItem> retrievePlayersOwnedBusinessList(ECPlayer player) {
        List<Business> businesses = this.businessRepository.findActiveBusinessesByPlayer(player.getId());
        return this.transformBusinessesToListItemList(businesses);
    }

    private List<BusinessListItem> transformBusinessesToListItemList(List<Business> businesses) {
        return businesses.stream().map(this::transformBusinessToListItem).toList();
    }

    private BusinessListItem transformBusinessToListItem(Business business) {
        CorePlayer owner = (CorePlayer)this.playerRepository.findByKey(business.getOwnerId());
        return new BusinessListItem(business.getId(), business.getName(), this.playerTransformer.toSimple(owner));
    }

    private void transferBusinessBankAccount(Business business, ECPlayer newOwner) {
        if (business.getOwnershipType() != BusinessOwnershipType.PUBLIC_LIMITED_COMPANY) {
            return;
        }
        BankAccount bankAccount = this.bankAccountSession.getAccountById(business.getBankAccountId());
        try {
            this.bankAccountSession.transferAccountOwnership(bankAccount, newOwner);
        }
        catch (CannotUpdateAccountException ex) {
            log.error("Could not transfer bank account for businesses. This could indicate the business bank account is not an external account", ex);
        }
    }
}

