/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.business.category;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.business.category.BusinessCategory;
import java.util.List;

public class BusinessCategoryDatabase
implements RepositoryDatasource<BusinessCategory, Integer> {
    @Override
    public List<BusinessCategory> retrieveAll() {
        return Query.selectAllFrom("BUSINESS_CATEGORY").where(QueryColumn.column("PUBLISHED", true)).getList(this::getBusinessCategoryFromResultRow);
    }

    private BusinessCategory getBusinessCategoryFromResultRow(ResultRow row) {
        int id = row.getInt("ID");
        String name = row.getString("NAME");
        String description = row.getString("DESCRIPTION");
        int inspectionPeriodDays = row.getInt("INSPECTION_PERIOD_DAYS");
        String inspectionGuide = row.getString("INSPECTION_GUIDE");
        boolean enabled = row.getBoolean("ENABLED");
        return new BusinessCategory(id, name, description, inspectionPeriodDays, inspectionGuide, enabled);
    }
}

