/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.business.inspection;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.business.inspection.BusinessInspection;
import java.sql.Date;
import java.util.List;

public class BusinessInspectionDatabase
implements RepositoryDatasource<BusinessInspection, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_BUSINESS_ID = "BUSINESS_ID";
    private static final String COLUMN_INSPECTOR_ID = "INSPECTOR_ID";
    private static final String COLUMN_TIME_STAMP = "TIME_STAMP";
    private static final String COLUMN_PASSED = "PASSED";
    private static final String COLUMN_NOTES = "NOTES";

    @Override
    public void create(BusinessInspection businessInspection) {
        Query.insertInto("BUSINESS_INSPECTION").columns(QueryColumn.column(COLUMN_BUSINESS_ID, businessInspection.getBusinessId()), QueryColumn.column(COLUMN_INSPECTOR_ID, businessInspection.getInspectorId()), QueryColumn.column(COLUMN_TIME_STAMP, businessInspection.getTimeStamp()), QueryColumn.column(COLUMN_PASSED, businessInspection.isPassed()), QueryColumn.column(COLUMN_NOTES, businessInspection.getNotes())).executeGetGeneratedKey(businessInspection::setId);
    }

    @Override
    public List<BusinessInspection> retrieveAll() {
        return Query.selectAllFrom("BUSINESS_INSPECTION").getList(this::getBusinessInspectionFromResultRow);
    }

    private BusinessInspection getBusinessInspectionFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        int businessId = row.getInt(COLUMN_BUSINESS_ID);
        int inspectorId = row.getInt(COLUMN_INSPECTOR_ID);
        Date timeStamp = row.getNullableDate(COLUMN_TIME_STAMP);
        boolean passed = row.getBoolean(COLUMN_PASSED);
        String notes = row.getString(COLUMN_NOTES);
        return new BusinessInspection(id, businessId, inspectorId, timeStamp, passed, notes);
    }
}

