/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.business.inspection;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.base.repository.RepositorySearchQuery;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.business.inspection.BusinessInspection;
import com.equestricraft.core.business.inspection.BusinessInspectionDatabase;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public class BusinessInspectionRepository
extends Repository<BusinessInspection, Integer> {
    @Service
    private BusinessInspectionDatabase businessInspectionDatabase;

    @Override
    protected RepositoryDatasource<BusinessInspection, Integer> getDatasource() {
        return this.businessInspectionDatabase;
    }

    public Optional<BusinessInspection> findMostRecentInspectionByBusinessId(int businessId) {
        RepositorySearchQuery<BusinessInspection> query = this.createSearchQuery();
        query.filter(bi -> bi.getBusinessId() == businessId);
        query.sortReverse(Comparator.comparing(BusinessInspection::getTimeStamp));
        return query.single();
    }

    public List<BusinessInspection> findOrderedInspectionsByBusinessId(int businessId) {
        RepositorySearchQuery<BusinessInspection> query = this.createSearchQuery();
        query.filter(bi -> bi.getBusinessId() == businessId);
        query.sortReverse(Comparator.comparing(BusinessInspection::getTimeStamp));
        return query.many();
    }
}

