/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.business.inspection;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.business.Business;
import com.equestricraft.core.business.BusinessSession;
import com.equestricraft.core.business.BusinessSettings;
import com.equestricraft.core.business.inspection.BusinessInspection;
import com.equestricraft.core.business.inspection.BusinessInspectionRepository;
import com.equestricraft.core.business.inspection.BusinessInspectionSession;
import java.util.Date;

public class BusinessInspectionSessionImpl
implements BusinessInspectionSession {
    @Service
    private BusinessInspectionRepository businessInspectionRepository;
    @Service
    private BusinessSession businessSession;

    @Override
    public void addBusinessInspection(Business business, int inspectingPlayerId, boolean passed, String notes) {
        Date now = new Date();
        BusinessInspection inspection = new BusinessInspection(0, business.getId(), inspectingPlayerId, now, passed, notes);
        this.businessInspectionRepository.add(inspection);
        business.setLastInspection(now);
        Date nextInspection = passed ? this.businessSession.calculateEarliestInspectionDateFromNow(business.getCategoryIds()) : this.calculateNextInspectionDueDateResit();
        business.setInspectionDue(nextInspection);
        business.save();
    }

    private Date calculateNextInspectionDueDateResit() {
        return DateUtils.futureDaysOffset(BusinessSettings.getInspectionFailsResetDays());
    }
}

