/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.business.invoice;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.business.invoice.BusinessInvoice;
import java.util.List;

public class BusinessInvoiceDatabase
implements RepositoryDatasource<BusinessInvoice, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_BUSINESS_ID = "BUSINESS_ID";
    private static final String COLUMN_TO_PLAYER_ID = "TO_PLAYER_ID";
    private static final String COLUMN_TO_BUSINESS_ID = "TO_BUSINESS_ID";
    private static final String COLUMN_INVOICE_NUMBER = "INVOICE_NUMBER";
    private static final String COLUMN_DESCRIPTION = "DESCRIPTION";
    private static final String COLUMN_AMOUNT = "AMOUNT";
    private static final String COLUMN_PAID = "PAID";

    @Override
    public void create(BusinessInvoice businessInvoice) {
        Query.insertInto("BUSINESS_INVOICE").columns(QueryColumn.column(COLUMN_BUSINESS_ID, businessInvoice.getBusinessId()), QueryColumn.column(COLUMN_TO_PLAYER_ID, businessInvoice.getToPlayerId()), QueryColumn.column(COLUMN_TO_BUSINESS_ID, businessInvoice.getToBusinessId()), QueryColumn.column(COLUMN_INVOICE_NUMBER, businessInvoice.getInvoiceNumber()), QueryColumn.column(COLUMN_DESCRIPTION, businessInvoice.getDescription()), QueryColumn.column(COLUMN_AMOUNT, businessInvoice.getAmount()), QueryColumn.column(COLUMN_PAID, businessInvoice.isPaid())).executeGetGeneratedKey(businessInvoice::setId);
    }

    @Override
    public List<BusinessInvoice> retrieveAll() {
        return Query.selectAllFrom("BUSINESS_INVOICE").getList(this::getBusinessInvoiceFromResultRow);
    }

    private BusinessInvoice getBusinessInvoiceFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        int businessId = row.getInt(COLUMN_BUSINESS_ID);
        Integer toPlayerId = row.getNullableInt(COLUMN_TO_PLAYER_ID);
        Integer toBusinessId = row.getNullableInt(COLUMN_TO_BUSINESS_ID);
        int invoiceNumber = row.getInt(COLUMN_INVOICE_NUMBER);
        String description = row.getString(COLUMN_DESCRIPTION);
        double amount = row.getDouble(COLUMN_AMOUNT);
        boolean paid = row.getBoolean(COLUMN_PAID);
        return new BusinessInvoice(id, businessId, toPlayerId, toBusinessId, invoiceNumber, description, amount, paid);
    }

    @Override
    public void update(BusinessInvoice businessInvoice) {
        Query.update("BUSINESS_INVOICE").set(QueryColumn.column(COLUMN_PAID, businessInvoice.isPaid())).where(QueryColumn.column(COLUMN_ID, businessInvoice.getId())).execute();
    }
}

