/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.business.invoice;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.base.repository.RepositorySearchQuery;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.business.invoice.BusinessInvoice;
import com.equestricraft.core.business.invoice.BusinessInvoiceDatabase;
import java.util.List;

public class BusinessInvoiceRepository
extends Repository<BusinessInvoice, Integer> {
    @Service
    private BusinessInvoiceDatabase businessInvoiceDatabase;

    @Override
    protected RepositoryDatasource<BusinessInvoice, Integer> getDatasource() {
        return this.businessInvoiceDatabase;
    }

    public List<BusinessInvoice> findUnpaidBusinessInvoicesByBusiness(int businessId) {
        RepositorySearchQuery<BusinessInvoice> query = this.createSearchQuery();
        query.filterNot(BusinessInvoice::isPaid);
        query.filter(b -> b.getBusinessId() == businessId);
        return query.many();
    }

    public List<BusinessInvoice> findUnpaidBusinessInvoicesByToPlayer(int toPlayerId) {
        RepositorySearchQuery<BusinessInvoice> query = this.createSearchQuery();
        query.filterNot(BusinessInvoice::isPaid);
        query.filter(b -> b.getToPlayerId() == toPlayerId);
        return query.many();
    }

    public List<BusinessInvoice> findUnpaidBusinessInvoicesByToBusiness(int toBusinessId) {
        RepositorySearchQuery<BusinessInvoice> query = this.createSearchQuery();
        query.filterNot(BusinessInvoice::isPaid);
        query.filter(b -> b.getToBusinessId() == toBusinessId);
        return query.many();
    }
}

