/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.business.invoice;

import com.equestricraft.base.database.TransactionManagement;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.business.Business;
import com.equestricraft.core.business.BusinessRepository;
import com.equestricraft.core.business.invoice.BusinessInvoice;
import com.equestricraft.core.business.invoice.BusinessInvoiceRepository;
import com.equestricraft.core.business.invoice.BusinessInvoiceSession;
import com.equestricraft.core.economy.Economy;
import com.equestricraft.core.economy.EconomyException;
import com.equestricraft.core.economy.account.BankAccountHoldingEntity;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerRepository;

@TransactionManagement
public class BusinessInvoiceSessionImpl
implements BusinessInvoiceSession {
    @Service
    private BusinessInvoiceRepository businessInvoiceRepository;
    @Service
    private BusinessRepository businessRepository;
    @Service
    private PlayerRepository playerRepository;
    @Service
    private Economy economy;

    @Override
    public BusinessInvoice createInvoice(Business business, ECPlayer toPlayer, String description, double amount) {
        return this.createInvoice(business, toPlayer, null, description, amount);
    }

    @Override
    public BusinessInvoice createInvoice(Business business, Business toBusiness, String description, double amount) {
        return this.createInvoice(business, null, toBusiness, description, amount);
    }

    private BusinessInvoice createInvoice(Business business, ECPlayer toPlayer, Business toBusiness, String description, double amount) {
        if (toPlayer == null && toBusiness == null) {
            throw new IllegalArgumentException("Invoices must have either a target player or target business");
        }
        int invoiceNumber = business.getNextInvoiceNumber();
        BusinessInvoice invoice = new BusinessInvoice(0, business.getId(), toPlayer != null ? Integer.valueOf(toPlayer.getId()) : null, toBusiness != null ? Integer.valueOf(toBusiness.getId()) : null, invoiceNumber, description, amount, false);
        business.setNextInvoiceNumber(invoiceNumber + 1);
        return this.businessInvoiceRepository.add(invoice);
    }

    @Override
    public void payInvoice(BusinessInvoice businessInvoice) throws EconomyException {
        if (businessInvoice.getToPlayerId() != null) {
            this.payPlayerInvoice(businessInvoice);
        } else if (businessInvoice.getToBusinessId() != null) {
            this.payBusinessInvoice(businessInvoice);
        } else {
            throw new IllegalArgumentException(String.format("Invalid invoice, no target: %s", businessInvoice.getId()));
        }
        businessInvoice.setPaid(true);
        businessInvoice.save();
    }

    private void payPlayerInvoice(BusinessInvoice businessInvoice) throws EconomyException {
        Business business = (Business)this.businessRepository.findByKey(businessInvoice.getBusinessId());
        CorePlayer fromPlayer = (CorePlayer)this.playerRepository.findByKey(businessInvoice.getToPlayerId());
        String reason = this.buildTransactionReason(business, businessInvoice);
        fromPlayer.getEconomy().sendTo(business, businessInvoice.getAmount(), reason);
    }

    private void payBusinessInvoice(BusinessInvoice businessInvoice) throws EconomyException {
        Business business = (Business)this.businessRepository.findByKey(businessInvoice.getBusinessId());
        Business fromBusiness = (Business)this.businessRepository.findByKey(businessInvoice.getToBusinessId());
        String reason = this.buildTransactionReason(business, businessInvoice);
        this.economy.transfer((BankAccountHoldingEntity)fromBusiness, (BankAccountHoldingEntity)business, businessInvoice.getAmount(), reason);
    }

    private String buildTransactionReason(Business business, BusinessInvoice businessInvoice) {
        return String.format("%s #%s", business.getName(), businessInvoice.getInvoiceNumber());
    }
}

