/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.business.registration;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.common.BusinessOwnershipType;
import com.equestricraft.common.BusinessRegistrationRequestStatus;
import com.equestricraft.core.business.registration.BusinessRegistrationRequest;
import java.util.List;

public class BusinessRegistrationRequestDatabase
implements RepositoryDatasource<BusinessRegistrationRequest, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";
    private static final String COLUMN_OWNERSHIP_TYPE = "OWNERSHIP_TYPE";
    private static final String COLUMN_BUSINESS_NAME = "BUSINESS_NAME";
    private static final String COLUMN_REQUEST_BODY = "REQUEST_BODY";
    private static final String COLUMN_STATUS = "STATUS";
    private static final String COLUMN_STATUS_MESSAGE = "STATUS_MESSAGE";
    private static final String COLUMN_BUSINESS_ID = "BUSINESS_ID";
    private static final String COLUMN_REGISTRATION_REQUEST_ID = "REGISTRATION_REQUEST_ID";
    private static final String COLUMN_CATEGORY_ID = "CATEGORY_ID";

    @Override
    public void create(BusinessRegistrationRequest request) {
        Query.insertInto("BUSINESS_REGISTRATION_REQUEST").columns(QueryColumn.column(COLUMN_PLAYER_ID, request.getPlayerId()), QueryColumn.column(COLUMN_OWNERSHIP_TYPE, request.getOwnershipType()), QueryColumn.column(COLUMN_BUSINESS_NAME, request.getBusinessName()), QueryColumn.column(COLUMN_REQUEST_BODY, request.getRequestBody()), QueryColumn.column(COLUMN_STATUS, request.getBusinessRegistrationRequestStatus().name()), QueryColumn.column(COLUMN_STATUS_MESSAGE, request.getStatusMessage()), QueryColumn.column(COLUMN_BUSINESS_ID, request.getBusinessId())).executeGetGeneratedKey(request::setId);
        for (Integer categoryId : request.getCategoryIds()) {
            Query.insertInto("BUSINESS_REGISTRATION_REQUEST_CATEGORY").columns(QueryColumn.column(COLUMN_REGISTRATION_REQUEST_ID, request.getId()), QueryColumn.column(COLUMN_CATEGORY_ID, categoryId)).execute();
        }
    }

    @Override
    public List<BusinessRegistrationRequest> retrieveAll() {
        return Query.selectAllFrom("BUSINESS_REGISTRATION_REQUEST").getList(this::getBusinessRegistrationRequestFromResultRow);
    }

    private BusinessRegistrationRequest getBusinessRegistrationRequestFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        int playerId = row.getInt(COLUMN_PLAYER_ID);
        BusinessOwnershipType ownershipType = row.getEnum(COLUMN_OWNERSHIP_TYPE, BusinessOwnershipType.class);
        String businessName = row.getString(COLUMN_BUSINESS_NAME);
        String requestBody = row.getString(COLUMN_REQUEST_BODY);
        BusinessRegistrationRequestStatus status = row.getEnum(COLUMN_STATUS, BusinessRegistrationRequestStatus.class);
        String statusMessage = row.getNullableString(COLUMN_STATUS_MESSAGE);
        Integer businessId = row.getNullableInt(COLUMN_BUSINESS_ID);
        List<Integer> categoryIds = this.retrieveCategoryIdsForRegistrationRequest(id);
        return new BusinessRegistrationRequest(id, playerId, ownershipType, businessName, requestBody, status, statusMessage, businessId, categoryIds);
    }

    private List<Integer> retrieveCategoryIdsForRegistrationRequest(int requestId) {
        return Query.selectAllFrom("BUSINESS_REGISTRATION_REQUEST_CATEGORY").where(QueryColumn.column(COLUMN_REGISTRATION_REQUEST_ID, requestId)).getList(row -> row.getInt(COLUMN_CATEGORY_ID));
    }

    @Override
    public void update(BusinessRegistrationRequest businessRegistrationRequest) {
        Query.update("BUSINESS_REGISTRATION_REQUEST").set(QueryColumn.column(COLUMN_BUSINESS_NAME, businessRegistrationRequest.getBusinessName()), QueryColumn.column(COLUMN_OWNERSHIP_TYPE, businessRegistrationRequest.getOwnershipType()), QueryColumn.column(COLUMN_REQUEST_BODY, businessRegistrationRequest.getRequestBody()), QueryColumn.column(COLUMN_STATUS, businessRegistrationRequest.getBusinessRegistrationRequestStatus()), QueryColumn.column(COLUMN_STATUS_MESSAGE, businessRegistrationRequest.getStatusMessage()), QueryColumn.column(COLUMN_BUSINESS_ID, businessRegistrationRequest.getBusinessId())).where(QueryColumn.column(COLUMN_ID, businessRegistrationRequest.getId())).execute();
        Query.deleteFrom("BUSINESS_REGISTRATION_REQUEST_CATEGORY").where(QueryColumn.column(COLUMN_REGISTRATION_REQUEST_ID, businessRegistrationRequest.getId())).execute();
        for (Integer categoryId : businessRegistrationRequest.getCategoryIds()) {
            Query.insertInto("BUSINESS_REGISTRATION_REQUEST_CATEGORY").columns(QueryColumn.column(COLUMN_REGISTRATION_REQUEST_ID, businessRegistrationRequest.getId()), QueryColumn.column(COLUMN_CATEGORY_ID, categoryId)).execute();
        }
    }
}

