/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.business.registration;

import com.equestricraft.base.database.TransactionManagement;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.BusinessOwnershipType;
import com.equestricraft.common.BusinessRegistrationRequestStatus;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.common.util.StringUtils;
import com.equestricraft.core.business.Business;
import com.equestricraft.core.business.BusinessRepository;
import com.equestricraft.core.business.BusinessSession;
import com.equestricraft.core.business.registration.BusinessRegistrationRequest;
import com.equestricraft.core.business.registration.BusinessRegistrationRequestDto;
import com.equestricraft.core.business.registration.BusinessRegistrationRequestRepository;
import com.equestricraft.core.business.registration.BusinessRegistrationRequestSession;
import com.equestricraft.core.business.registration.CannotApproveRequestException;
import com.equestricraft.core.business.registration.CannotDeleteRequestException;
import com.equestricraft.core.business.registration.CannotDenyRequestException;
import com.equestricraft.core.business.registration.CannotSubmitRequestException;
import com.equestricraft.core.business.registration.RequestApproveResponse;
import com.equestricraft.core.economy.account.AccountNameAlreadyUsedException;
import com.equestricraft.core.economy.account.BankAccount;
import com.equestricraft.core.economy.account.BankAccountSession;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerRepository;
import java.util.Date;
import java.util.List;
import java.util.Optional;

@TransactionManagement
public class BusinessRegistrationRequestSessionImpl
implements BusinessRegistrationRequestSession {
    @Service
    private BusinessRegistrationRequestRepository businessRegistrationRequestRepository;
    @Service
    private BusinessRepository businessRepository;
    @Service
    private BusinessSession businessSession;
    @Service
    private PlayerRepository playerRepository;
    @Service
    private BankAccountSession bankAccountSession;

    @Override
    public BusinessRegistrationRequest createNewRequest(ECPlayer player, BusinessRegistrationRequestDto request) {
        List<Integer> categoryIds = request.categoryIds().stream().distinct().toList();
        BusinessRegistrationRequest newRegistrationRequest = new BusinessRegistrationRequest(0, player.getId(), request.ownershipType(), StringUtils.removeExtraSpaces(request.businessName()), request.requestBody(), BusinessRegistrationRequestStatus.DRAFT, null, null, categoryIds);
        return this.businessRegistrationRequestRepository.add(newRegistrationRequest);
    }

    @Override
    public void updateExistingRequest(BusinessRegistrationRequest businessRegistrationRequest, BusinessRegistrationRequestDto request) throws CannotSubmitRequestException {
        this.ensureCanBeUpdated(businessRegistrationRequest);
        businessRegistrationRequest.setBusinessName(StringUtils.removeExtraSpaces(request.businessName()));
        businessRegistrationRequest.setOwnershipType(request.ownershipType());
        businessRegistrationRequest.setRequestBody(businessRegistrationRequest.getRequestBody());
        businessRegistrationRequest.setCategoryIds(businessRegistrationRequest.getCategoryIds());
        businessRegistrationRequest.save();
    }

    private void ensureCanBeUpdated(BusinessRegistrationRequest request) throws CannotSubmitRequestException {
        if (request.getBusinessRegistrationRequestStatus() != BusinessRegistrationRequestStatus.DRAFT && request.getBusinessRegistrationRequestStatus() != BusinessRegistrationRequestStatus.DENIED) {
            throw new CannotSubmitRequestException(I18n.getLabel("business.request.update.cannot-update-draft-denied"));
        }
    }

    @Override
    public void submitRequest(BusinessRegistrationRequest request) throws CannotSubmitRequestException {
        this.ensureCanBeSubmitted(request);
        request.setBusinessRegistrationRequestStatus(BusinessRegistrationRequestStatus.SUBMITTED);
        request.setStatusMessage(null);
        request.save();
    }

    private void ensureCanBeSubmitted(BusinessRegistrationRequest request) throws CannotSubmitRequestException {
        if (request.getBusinessRegistrationRequestStatus() != BusinessRegistrationRequestStatus.DRAFT && request.getBusinessRegistrationRequestStatus() != BusinessRegistrationRequestStatus.DENIED) {
            throw new CannotSubmitRequestException(I18n.getLabel("business.request.submit.cannot-submit-draft-denied"));
        }
        if (request.getCategoryIds().isEmpty()) {
            throw new CannotSubmitRequestException(I18n.getLabel("business.request.submit.no-categories"));
        }
    }

    @Override
    public RequestApproveResponse approveRequest(BusinessRegistrationRequest request) throws CannotApproveRequestException, AccountNameAlreadyUsedException {
        this.ensureCanBeApproved(request);
        request.setBusinessRegistrationRequestStatus(BusinessRegistrationRequestStatus.APPROVED);
        request.setStatusMessage(null);
        Business newBusiness = this.buildBusinessFromRequest(request);
        newBusiness = this.businessRepository.add(newBusiness);
        request.setBusinessId(newBusiness.getId());
        request.save();
        Optional<BankAccount> newBankAccount = this.createBusinessBankAccount(newBusiness);
        return new RequestApproveResponse(newBusiness.getId(), newBankAccount.map(BankAccount::getId).orElse(null), DateUtils.daysUntil(newBusiness.getInspectionDue()));
    }

    private void ensureCanBeApproved(BusinessRegistrationRequest request) throws CannotApproveRequestException {
        if (request.getBusinessRegistrationRequestStatus() != BusinessRegistrationRequestStatus.SUBMITTED) {
            throw new CannotApproveRequestException(I18n.getLabel("business.request.approve.not-submitted"));
        }
    }

    private Business buildBusinessFromRequest(BusinessRegistrationRequest businessRegistrationRequest) {
        List<Integer> categoryIds = businessRegistrationRequest.getCategoryIds();
        Date firstInspectionDate = this.businessSession.calculateEarliestInspectionDateFromNow(categoryIds);
        return new Business(0, businessRegistrationRequest.getBusinessName(), businessRegistrationRequest.getPlayerId(), businessRegistrationRequest.getOwnershipType(), new Date(), null, firstInspectionDate, true, null, 1, categoryIds);
    }

    private Optional<BankAccount> createBusinessBankAccount(Business business) throws AccountNameAlreadyUsedException {
        if (business.getOwnershipType() != BusinessOwnershipType.PUBLIC_LIMITED_COMPANY) {
            return Optional.empty();
        }
        CorePlayer player = (CorePlayer)this.playerRepository.findByKey(business.getOwnerId());
        BankAccount newBankAccount = this.bankAccountSession.createExternalAccount(player, I18n.getLabel("business.bank-account.name", business.getName()));
        business.setBankAccountId(newBankAccount.getId());
        return Optional.of(newBankAccount);
    }

    @Override
    public void denyRequest(BusinessRegistrationRequest request, String reason) throws CannotDenyRequestException {
        this.ensureCanBeDenied(request);
        request.setBusinessRegistrationRequestStatus(BusinessRegistrationRequestStatus.DENIED);
        request.setStatusMessage(reason);
        request.save();
    }

    private void ensureCanBeDenied(BusinessRegistrationRequest request) throws CannotDenyRequestException {
        if (request.getBusinessRegistrationRequestStatus() != BusinessRegistrationRequestStatus.SUBMITTED) {
            throw new CannotDenyRequestException(I18n.getLabel("business.request.deny.not-submitted"));
        }
    }

    @Override
    public void deleteRequest(BusinessRegistrationRequest request, String reason) throws CannotDeleteRequestException {
        BusinessRegistrationRequestSessionImpl.ensureCanBeDeleted(request);
        request.setBusinessRegistrationRequestStatus(BusinessRegistrationRequestStatus.DELETED);
        request.setStatusMessage(reason);
        request.save();
    }

    private static void ensureCanBeDeleted(BusinessRegistrationRequest request) throws CannotDeleteRequestException {
        if (request.getBusinessRegistrationRequestStatus() == BusinessRegistrationRequestStatus.APPROVED || request.getBusinessRegistrationRequestStatus() == BusinessRegistrationRequestStatus.SUBMITTED) {
            throw new CannotDeleteRequestException(I18n.getLabel("business.request.delete.cannot-delete", request.getBusinessRegistrationRequestStatus().name()));
        }
    }
}

