/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.character;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.common.Argb;
import com.equestricraft.core.character.CharacterProfile;
import java.util.List;

public class CharacterProfileDatabase
implements RepositoryDatasource<CharacterProfile, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_NAME = "NAME";
    private static final String COLUMN_IDENTIFIER = "IDENTIFIER";
    private static final String COLUMN_DESCRIPTION = "DESCRIPTION";
    private static final String COLUMN_LINE_PREFIX = "LINE_PREFIX";
    private static final String COLUMN_COLOR = "COLOR";
    private static final String COLUMN_WAIT_MESSAGE = "WAIT_MESSAGE";
    private static final String COLUMN_INITIAL_FRIENDSHIP_PERCENTAGE = "INITIAL_FRIENDSHIP_PERCENTAGE";

    @Override
    public List<CharacterProfile> retrieveAll() {
        return Query.selectAllFrom("CHARACTER_PROFILE").getList(this::getCharacterFromResultRow);
    }

    private CharacterProfile getCharacterFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        String name = row.getString(COLUMN_NAME);
        String identifier = row.getString(COLUMN_IDENTIFIER);
        String description = row.getString(COLUMN_DESCRIPTION);
        String linePrefix = row.getString(COLUMN_LINE_PREFIX);
        Argb color = row.getArgbColor(COLUMN_COLOR);
        String waitMessage = row.getString(COLUMN_WAIT_MESSAGE);
        double initialFriendshipPercentage = row.getDouble(COLUMN_INITIAL_FRIENDSHIP_PERCENTAGE);
        return new CharacterProfile(id, name, identifier, description, linePrefix, color, waitMessage, initialFriendshipPercentage);
    }
}

