/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.chatcommandlog;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.ChatCommandType;
import com.equestricraft.core.chatcommandlog.ChatCommandLog;
import com.equestricraft.core.chatcommandlog.ChatCommandLogRepository;
import com.equestricraft.core.chatcommandlog.ChatCommandLogService;
import java.util.LinkedList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class ChatCommandLogServiceImpl
implements ChatCommandLogService {
    @Service
    private ChatCommandLogRepository chatCommandLogRepository;
    private final BlockingQueue<ChatCommandLog> queue = new LinkedBlockingQueue<ChatCommandLog>();

    @Override
    public void logChat(int playerId, String message) {
        this.logChatCommand(playerId, message, ChatCommandType.CHAT);
    }

    @Override
    public void logCommand(int playerId, String message) {
        this.logChatCommand(playerId, message, ChatCommandType.COMMAND);
    }

    private void logChatCommand(int playerId, String message, ChatCommandType chatCommandType) {
        ChatCommandLog chatCommandLog = new ChatCommandLog(playerId, System.currentTimeMillis(), chatCommandType, message);
        this.queue.add(chatCommandLog);
    }

    @Override
    public synchronized void processQueue() {
        LinkedList<ChatCommandLog> chatCommandLogToPersist = new LinkedList<ChatCommandLog>();
        int amountTransferred = this.queue.drainTo(chatCommandLogToPersist);
        if (amountTransferred > 0) {
            this.chatCommandLogRepository.processChatCommandLogs(chatCommandLogToPersist);
        }
    }
}

