/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.chatcommandlog;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.ThreadUtils;
import com.equestricraft.core.chatcommandlog.ChatCommandLogService;
import com.equestricraft.core.system.SubSystem;
import java.util.Timer;
import java.util.TimerTask;

public class ChatCommandLogSystem
implements SubSystem {
    @Service
    private ChatCommandLogService chatCommandLogService;
    private final Timer timer = new Timer(ThreadUtils.threadName("chat-command-processor"));

    @Override
    public void onEnable() {
        long period = this.getProcessPeriod();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                ChatCommandLogSystem.this.chatCommandLogService.processQueue();
            }
        };
        this.timer.schedule(task, period, period);
    }

    private long getProcessPeriod() {
        String interval = System.getenv("EC_CHAT_COMMAND_PROCESS_INTERVAL");
        try {
            return 1000L * (long)Integer.parseInt(interval);
        }
        catch (Exception ex) {
            return 5000L;
        }
    }

    @Override
    public void onDisable() {
        this.timer.cancel();
        this.chatCommandLogService.processQueue();
    }
}

