/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.club;

import com.equestricraft.base.database.TransactionManagement;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.ColorsHelper;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.StringUtils;
import com.equestricraft.core.blockedphrase.BlockedPhraseException;
import com.equestricraft.core.blockedphrase.BlockedPhraseService;
import com.equestricraft.core.club.Club;
import com.equestricraft.core.club.ClubCreateException;
import com.equestricraft.core.club.ClubCreateResponse;
import com.equestricraft.core.club.ClubCreateSession;
import com.equestricraft.core.club.ClubRankException;
import com.equestricraft.core.club.ClubRepository;
import com.equestricraft.core.club.ClubSession;
import com.equestricraft.core.club.ClubSettings;
import com.equestricraft.core.club.ClubUtilities;
import com.equestricraft.core.club.rank.ClubPermissionLevel;
import com.equestricraft.core.club.rank.ClubRankSession;
import com.equestricraft.core.economy.EconomyException;
import com.equestricraft.core.economy.SingleAccountEconomyResponse;
import com.equestricraft.core.economy.account.AccountNameAlreadyUsedException;
import com.equestricraft.core.economy.account.BankAccount;
import com.equestricraft.core.economy.account.BankAccountSession;
import com.equestricraft.core.player.ECPlayer;
import java.util.Date;
import java.util.Optional;

@TransactionManagement
public class ClubCreateSessionImpl
implements ClubCreateSession {
    @Service
    private ClubRepository clubRepository;
    @Service
    private ClubSession clubSession;
    @Service
    private ClubRankSession clubRankSession;
    @Service
    private BankAccountSession bankAccountSession;
    @Service
    private BlockedPhraseService blockedPhraseService;

    @Override
    public ClubCreateResponse createClub(ECPlayer owner, String clubName, String chatTag) throws ClubCreateException {
        try {
            clubName = StringUtils.removeExtraSpaces(clubName);
            clubName = ColorsHelper.stripColorsAndFormatting(clubName);
            chatTag = StringUtils.removeExtraSpaces(chatTag);
            ClubUtilities.ensureClubNameLength(clubName);
            ClubUtilities.ensureClubTagLength(chatTag);
            this.ensureClubNameNotTaken(clubName);
            this.ensureChatTagNotTaken(chatTag);
            this.ensurePlayerDoesNotAlreadyOwnClub(owner);
            this.ensurePlayerHasEnoughXp(owner);
            this.blockedPhraseService.ensureNoBlockedPhrases(clubName);
            this.blockedPhraseService.ensureNoBlockedPhrases(chatTag);
            SingleAccountEconomyResponse economyResponse = this.withdrawClubCreateFee(owner);
            BankAccount bankAccount = this.createClubBankAccount(owner, clubName);
            Club club = this.buildNewClub(owner.getId(), clubName, chatTag, bankAccount);
            club = this.clubRepository.add(club);
            this.clubRankSession.createClubRank(club, I18n.getLabel("club.first-rank-name"), ClubPermissionLevel.MEMBER);
            owner.getClub().refreshClubData();
            return new ClubCreateResponse(club, economyResponse.amountFormatted(), economyResponse.balanceFormatted());
        }
        catch (BlockedPhraseException | ClubRankException ex) {
            throw new ClubCreateException(ex.getMessage());
        }
    }

    private void ensureClubNameNotTaken(String name) throws ClubCreateException {
        Optional<Club> existing = this.clubRepository.findActiveClubByName(name);
        if (existing.isPresent()) {
            throw new ClubCreateException(I18n.getLabel("club.create.name-already-taken"));
        }
    }

    private void ensureChatTagNotTaken(String chatTag) throws ClubCreateException {
        Optional<Club> existing = this.clubRepository.findActiveClubByChatTag(chatTag);
        if (existing.isPresent()) {
            throw new ClubCreateException(I18n.getLabel("club.create.chat-tag-already-taken"));
        }
    }

    private Club buildNewClub(int ownerId, String clubName, String chatTag, BankAccount bankAccount) {
        return new Club(0, clubName, chatTag, ownerId, new Date(), bankAccount.getId(), false, false);
    }

    private void ensurePlayerDoesNotAlreadyOwnClub(ECPlayer player) throws ClubCreateException {
        if (this.clubSession.doesPlayerOwnClub(player)) {
            throw new ClubCreateException(I18n.getLabel("club.create.already-own"));
        }
    }

    private void ensurePlayerHasEnoughXp(ECPlayer player) throws ClubCreateException {
        if (!this.clubSession.isPlayerHighEnoughRankToCreateClub(player)) {
            throw new ClubCreateException(I18n.getLabel("club.create.not-enough-xp"));
        }
    }

    private SingleAccountEconomyResponse withdrawClubCreateFee(ECPlayer player) throws ClubCreateException {
        try {
            return player.getEconomy().withdraw(ClubSettings.getCreatePrice().intValue(), I18n.getLabel("club.create.transaction-reason"), "Club");
        }
        catch (EconomyException ex) {
            throw new ClubCreateException(ex.getMessage());
        }
    }

    private BankAccount createClubBankAccount(ECPlayer player, String clubName) throws ClubCreateException {
        try {
            return this.bankAccountSession.createExternalAccount(player, I18n.getLabel("club.bank-account.name", clubName));
        }
        catch (AccountNameAlreadyUsedException ex) {
            throw new ClubCreateException(ex);
        }
    }
}

