/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.club;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.club.Club;
import java.sql.Date;
import java.util.List;

public class ClubDatabase
implements RepositoryDatasource<Club, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_NAME = "NAME";
    private static final String COLUMN_CHAT_TAG = "CHAT_TAG";
    private static final String COLUMN_OWNER_ID = "OWNER_ID";
    private static final String COLUMN_CREATED_DATE = "CREATED_DATE";
    private static final String COLUMN_BANK_ACCOUNT_ID = "BANK_ACCOUNT_ID";
    private static final String COLUMN_ALLOW_JOIN_REQUESTS = "ALLOW_JOIN_REQUESTS";
    private static final String COLUMN_DISBANDED = "DISBANDED";

    @Override
    public void create(Club club) {
        Query.insertInto("CLUB").columns(QueryColumn.column(COLUMN_NAME, club.getName()), QueryColumn.column(COLUMN_CHAT_TAG, club.getChatTag()), QueryColumn.column(COLUMN_OWNER_ID, club.getOwnerId()), QueryColumn.column(COLUMN_CREATED_DATE, club.getCreatedDate()), QueryColumn.column(COLUMN_BANK_ACCOUNT_ID, club.getBankAccountId()), QueryColumn.column(COLUMN_ALLOW_JOIN_REQUESTS, club.isAllowJoinRequests()), QueryColumn.column(COLUMN_DISBANDED, club.isDisbanded())).executeGetGeneratedKey(club::setId);
    }

    @Override
    public List<Club> retrieveAll() {
        return Query.selectAllFrom("CLUB").getList(this::getClubFromResultRow);
    }

    private Club getClubFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        String name = row.getString(COLUMN_NAME);
        String clubTag = row.getString(COLUMN_CHAT_TAG);
        int ownerId = row.getInt(COLUMN_OWNER_ID);
        Date createdDate = row.getNullableDate(COLUMN_CREATED_DATE);
        Integer bankAccountId = row.getNullableInt(COLUMN_BANK_ACCOUNT_ID);
        boolean allowJoinRequests = row.getBoolean(COLUMN_ALLOW_JOIN_REQUESTS);
        boolean disbanded = row.getBoolean(COLUMN_DISBANDED);
        return new Club(id, name, clubTag, ownerId, createdDate, bankAccountId, allowJoinRequests, disbanded);
    }

    @Override
    public void update(Club club) {
        Query.update("CLUB").set(QueryColumn.column(COLUMN_NAME, club.getName()), QueryColumn.column(COLUMN_CHAT_TAG, club.getChatTag()), QueryColumn.column(COLUMN_OWNER_ID, club.getOwnerId()), QueryColumn.column(COLUMN_BANK_ACCOUNT_ID, club.getBankAccountId()), QueryColumn.column(COLUMN_ALLOW_JOIN_REQUESTS, club.isAllowJoinRequests()), QueryColumn.column(COLUMN_DISBANDED, club.isDisbanded())).where(QueryColumn.column(COLUMN_ID, club.getId())).execute();
    }
}

