/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.club;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.club.ClubPermission;
import com.equestricraft.core.club.ClubPermissionException;
import com.equestricraft.core.club.rank.ClubRank;
import com.equestricraft.core.player.ECPlayer;
import java.util.Optional;

public class ClubPermissionChecker {
    public static void ensureHasClubPermission(ECPlayer player, ClubPermission clubPermission) throws ClubPermissionException {
        if (!ClubPermissionChecker.hasPermission(player, clubPermission)) {
            throw new ClubPermissionException(I18n.getLabel("club.no-permission"));
        }
    }

    public static boolean hasPermission(ECPlayer player, ClubPermission clubPermission) {
        if (player.getClub().isClubOwner()) {
            return true;
        }
        Optional<ClubRank> rank = player.getClub().getRank();
        return rank.isPresent() && rank.get().getPermissionLevel().hasPermission(clubPermission);
    }

    private ClubPermissionChecker() {
    }
}

