/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.club;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.ColorsHelper;
import com.equestricraft.core.club.Club;
import com.equestricraft.core.club.ClubDatabase;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public class ClubRepository
extends Repository<Club, Integer> {
    @Service
    private ClubDatabase clubDatabase;

    @Override
    protected RepositoryDatasource<Club, Integer> getDatasource() {
        return this.clubDatabase;
    }

    public Optional<Club> findNonDisbandedClubByOwner(int ownerId) {
        return this.findSingleByPredicates(c -> c.getOwnerId() == ownerId, Predicate.not(Club::isDisbanded));
    }

    public List<Club> findAllNonDisbandedClubs() {
        return this.findListByPredicates(Predicate.not(Club::isDisbanded));
    }

    public Optional<Club> findActiveClubByName(String name) {
        return this.findSingleByPredicates(Predicate.not(Club::isDisbanded), c -> c.getName().equalsIgnoreCase(name));
    }

    public Optional<Club> findActiveClubByChatTag(String chatTag) {
        String fChatTag = ColorsHelper.stripColorsAndFormatting(chatTag);
        return this.findSingleByPredicates(Predicate.not(Club::isDisbanded), c -> ColorsHelper.stripColorsAndFormatting(c.getChatTag()).equalsIgnoreCase(fChatTag));
    }
}

