/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.club;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.ColorsHelper;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.StringUtils;
import com.equestricraft.core.club.Club;
import com.equestricraft.core.club.ClubInfo;
import com.equestricraft.core.club.ClubManageInfo;
import com.equestricraft.core.club.ClubNameUpdateException;
import com.equestricraft.core.club.ClubPermission;
import com.equestricraft.core.club.ClubPermissionChecker;
import com.equestricraft.core.club.ClubRepository;
import com.equestricraft.core.club.ClubSession;
import com.equestricraft.core.club.ClubSettings;
import com.equestricraft.core.club.ClubTagUpdateException;
import com.equestricraft.core.club.ClubUtilities;
import com.equestricraft.core.club.PlayerNotClubAdminException;
import com.equestricraft.core.club.PlayerNotInClubException;
import com.equestricraft.core.club.member.ClubMember;
import com.equestricraft.core.club.member.ClubMemberRepository;
import com.equestricraft.core.club.member.ClubMemberSession;
import com.equestricraft.core.club.rank.ClubPermissionLevel;
import com.equestricraft.core.club.rank.ClubRank;
import com.equestricraft.core.economy.Economy;
import com.equestricraft.core.economy.EconomyException;
import com.equestricraft.core.economy.account.BankAccount;
import com.equestricraft.core.economy.account.BankAccountSession;
import com.equestricraft.core.economy.account.CannotUpdateAccountException;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.core.player.PlayerTransformer;
import java.util.List;
import java.util.Optional;

public class ClubSessionImpl
implements ClubSession {
    @Service
    private ClubRepository clubRepository;
    @Service
    private ClubMemberRepository clubMemberRepository;
    @Service
    private ClubMemberSession clubMemberSession;
    @Service
    private BankAccountSession bankAccountSession;
    @Service
    private PlayerRepository playerRepository;
    @Service
    private Economy economy;
    @Service
    private PlayerTransformer playerTransformer;

    @Override
    public Optional<ClubManageInfo> getClubManageInfo(ECPlayer player) {
        Optional<Club> club = player.getClub().getClub();
        if (club.isPresent()) {
            Club c = club.get();
            ClubManageInfo info2 = new ClubManageInfo(c.getId(), c.getName(), ClubPermissionChecker.hasPermission(player, ClubPermission.MANAGE_JOIN_REQUESTS), ClubPermissionChecker.hasPermission(player, ClubPermission.SEND_INVITES), ClubPermissionChecker.hasPermission(player, ClubPermission.MANAGE_MEMBERS), ClubPermissionChecker.hasPermission(player, ClubPermission.EDIT_DETAILS), ClubPermissionChecker.hasPermission(player, ClubPermission.DISBAND_CLUB), c.isAllowJoinRequests());
            return Optional.of(info2);
        }
        return Optional.empty();
    }

    @Override
    public boolean doesPlayerOwnClub(ECPlayer player) {
        Optional<Club> existingClub = this.clubRepository.findNonDisbandedClubByOwner(player.getId());
        return existingClub.isPresent();
    }

    @Override
    public boolean isPlayerHighEnoughRankToCreateClub(ECPlayer player) {
        return player.getProgression().hasXp(ClubSettings.getCreateXpThreshold());
    }

    @Override
    public void depositClubBankAccount(Club club, double amount, String reason, String sourceDescription) throws EconomyException {
        this.economy.deposit(club, amount, reason, sourceDescription);
    }

    @Override
    public void withdrawClubBankAccount(Club club, double amount, String reason, String sourceDescription) throws EconomyException {
        this.economy.withdraw(club, amount, reason, sourceDescription);
    }

    @Override
    public void updateClubName(Club club, String newName) throws ClubNameUpdateException {
        newName = ColorsHelper.stripColorsAndFormatting(newName);
        newName = StringUtils.removeExtraSpaces(newName);
        ClubUtilities.ensureClubNameLength(newName);
        Optional<Club> existingClub = this.clubRepository.findActiveClubByName(newName);
        if (existingClub.isPresent() && existingClub.get().getId() != club.getId()) {
            throw new ClubNameUpdateException(I18n.getLabel("club.name.already-taken"));
        }
        club.setName(newName);
        club.save();
        this.renameBankAccount(club);
    }

    private void renameBankAccount(Club club) {
        BankAccount account = this.bankAccountSession.getAccountById(club.getBankAccountId());
        try {
            this.bankAccountSession.renameAccount(account, I18n.getLabel("club.bank-account.name", club.getName()));
        }
        catch (EconomyException economyException) {
            // empty catch block
        }
    }

    @Override
    public void updateClubTag(Club club, String newTag) throws ClubTagUpdateException {
        newTag = StringUtils.removeExtraSpaces(newTag);
        ClubUtilities.ensureClubTagLength(newTag);
        Optional<Club> existingClub = this.clubRepository.findActiveClubByChatTag(newTag);
        if (existingClub.isPresent() && existingClub.get().getId() != club.getId()) {
            throw new ClubTagUpdateException(I18n.getLabel("club.tag.already-taken"));
        }
        club.setChatTag(newTag);
        club.save();
    }

    @Override
    public void transferClubToAdmin(int clubId, ECPlayer newOwner) throws PlayerNotInClubException, CannotUpdateAccountException, PlayerNotClubAdminException {
        Club club = newOwner.getClub().getClub().orElseThrow(() -> new PlayerNotInClubException(I18n.getLabel("club.member.not-in-this-club")));
        ClubRank rank = newOwner.getClub().getRank().orElseThrow(() -> new PlayerNotClubAdminException(I18n.getLabel("club.transfer.player-not-admin")));
        if (club.getId() != clubId || rank.getPermissionLevel() != ClubPermissionLevel.ADMINISTRATOR) {
            throw new PlayerNotClubAdminException(I18n.getLabel("club.transfer.player-not-admin"));
        }
        newOwner.getClub().removeFromClub(club);
        club.setOwnerId(newOwner.getId());
        club.save();
        this.transferClubBankAccount(newOwner, club);
    }

    private void transferClubBankAccount(ECPlayer newOwner, Club club) throws CannotUpdateAccountException {
        BankAccount clubBankAccount = this.bankAccountSession.getAccountById(club.getBankAccountId());
        this.bankAccountSession.transferAccountOwnership(clubBankAccount, newOwner);
    }

    @Override
    public void disbandClub(Club club) throws EconomyException {
        BankAccount bankAccount = this.bankAccountSession.getEntitiesAccount(club);
        this.bankAccountSession.clearAccountToOwnersMain(bankAccount);
        club.setDisbanded(true);
        club.save();
        this.removeAllMembers(club);
        this.bankAccountSession.closeAccount(bankAccount);
        ECPlayer owner = club.getOwner();
        owner.getClub().refreshClubData();
    }

    private void removeAllMembers(Club club) {
        List<ClubMember> members = this.clubMemberRepository.findClubMembersByClub(club.getId());
        for (ClubMember member : members) {
            try {
                CorePlayer player = (CorePlayer)this.playerRepository.findByKey(member.getPlayerId());
                player.getClub().removeFromClub(club);
                player.notify(I18n.getLabel("club.disbanded.member-club-disbanded", club.getName()));
            }
            catch (PlayerNotInClubException playerNotInClubException) {}
        }
    }

    @Override
    public List<ClubInfo> getAllClubs() {
        List<Club> clubs = this.clubRepository.findAllNonDisbandedClubs();
        return clubs.stream().map(this::buildClubInfo).toList();
    }

    private ClubInfo buildClubInfo(Club c) {
        CorePlayer owner = c.getOwner().getCorePlayer();
        int memberCount = this.clubMemberSession.retrieveAllClubsMembers(c).size();
        return new ClubInfo(c.getId(), c.getName(), this.playerTransformer.toSimple(owner), c.getCreatedDate(), memberCount, c.isAllowJoinRequests());
    }

    @Override
    public boolean isClubOwner(int playerId) {
        return this.clubRepository.findNonDisbandedClubByOwner(playerId).isPresent();
    }
}

