/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.club.joinrequest;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.common.ClubJoinRequestSource;
import com.equestricraft.common.ClubJoinRequestStatus;
import com.equestricraft.core.club.joinrequest.ClubJoinRequest;
import java.sql.Date;
import java.util.List;

public class ClubJoinRequestDatabase
implements RepositoryDatasource<ClubJoinRequest, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_CLUB_ID = "CLUB_ID";
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";
    private static final String COLUMN_TIME_STAMP = "TIME_STAMP";
    private static final String COLUMN_SOURCE = "SOURCE";
    private static final String COLUMN_MESSAGE = "MESSAGE";
    private static final String COLUMN_STATUS = "STATUS";
    private static final String COLUMN_STATUS_MESSAGE = "STATUS_MESSAGE";

    @Override
    public void create(ClubJoinRequest clubJoinRequest) {
        Query.insertInto("CLUB_JOIN_REQUEST").columns(QueryColumn.column(COLUMN_CLUB_ID, clubJoinRequest.getClubId()), QueryColumn.column(COLUMN_PLAYER_ID, clubJoinRequest.getPlayerId()), QueryColumn.column(COLUMN_TIME_STAMP, clubJoinRequest.getTimeStamp()), QueryColumn.column(COLUMN_SOURCE, clubJoinRequest.getSource()), QueryColumn.column(COLUMN_MESSAGE, clubJoinRequest.getMessage()), QueryColumn.column(COLUMN_STATUS, clubJoinRequest.getStatus()), QueryColumn.column(COLUMN_STATUS_MESSAGE, clubJoinRequest.getStatusMessage())).executeGetGeneratedKey(clubJoinRequest::setId);
    }

    @Override
    public List<ClubJoinRequest> retrieveAll() {
        return Query.selectAllFrom("CLUB_JOIN_REQUEST").getList(this::getClubJoinRequestFromResultRow);
    }

    private ClubJoinRequest getClubJoinRequestFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        int clubId = row.getInt(COLUMN_CLUB_ID);
        int playerId = row.getInt(COLUMN_PLAYER_ID);
        Date timeStamp = row.getNullableDate(COLUMN_TIME_STAMP);
        ClubJoinRequestSource source2 = row.getEnum(COLUMN_SOURCE, ClubJoinRequestSource.class);
        String message = row.getString(COLUMN_MESSAGE);
        ClubJoinRequestStatus status = row.getEnum(COLUMN_STATUS, ClubJoinRequestStatus.class);
        String statusMessage = row.getString(COLUMN_STATUS_MESSAGE);
        return new ClubJoinRequest(id, clubId, playerId, timeStamp, source2, message, status, statusMessage);
    }

    @Override
    public void update(ClubJoinRequest clubJoinRequest) {
        Query.update("CLUB_JOIN_REQUEST").set(QueryColumn.column(COLUMN_STATUS, clubJoinRequest.getStatus()), QueryColumn.column(COLUMN_STATUS_MESSAGE, clubJoinRequest.getStatusMessage())).where(QueryColumn.column(COLUMN_ID, clubJoinRequest.getId())).execute();
    }
}

