/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.club.joinrequest;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.base.repository.RepositorySearchQuery;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.ClubJoinRequestSource;
import com.equestricraft.common.ClubJoinRequestStatus;
import com.equestricraft.core.club.joinrequest.ClubJoinRequest;
import com.equestricraft.core.club.joinrequest.ClubJoinRequestDatabase;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class ClubJoinRequestRepository
extends Repository<ClubJoinRequest, Integer> {
    @Service
    private ClubJoinRequestDatabase clubJoinRequestDatabase;

    @Override
    protected RepositoryDatasource<ClubJoinRequest, Integer> getDatasource() {
        return this.clubJoinRequestDatabase;
    }

    public List<ClubJoinRequest> findPendingJoinRequestsByClub(int clubId) {
        RepositorySearchQuery<ClubJoinRequest> query = this.createSearchQuery();
        query.filter(cjr -> cjr.getClubId() == clubId);
        query.filter(cjr -> cjr.getStatus() == ClubJoinRequestStatus.PENDING);
        query.filter(cjr -> cjr.getSource() == ClubJoinRequestSource.PLAYER);
        query.sort(Comparator.comparing(ClubJoinRequest::getTimeStamp));
        return query.many();
    }

    public List<ClubJoinRequest> findPendingOrDeniedJoinRequestsByPlayer(int playerId) {
        RepositorySearchQuery<ClubJoinRequest> query = this.createSearchQuery();
        query.filter(cjr -> cjr.getPlayerId() == playerId);
        query.filter(cjr -> cjr.getStatus() == ClubJoinRequestStatus.PENDING || cjr.getStatus() == ClubJoinRequestStatus.DENIED);
        query.filter(cjr -> cjr.getSource() == ClubJoinRequestSource.PLAYER);
        return query.many();
    }

    public Optional<ClubJoinRequest> findPendingJoinRequestByClubAndPlayer(int clubId, int playerId) {
        RepositorySearchQuery<ClubJoinRequest> query = this.createSearchQuery();
        query.filter(cjr -> cjr.getClubId() == clubId);
        query.filter(cjr -> cjr.getPlayerId() == playerId);
        query.filter(cjr -> cjr.getStatus() == ClubJoinRequestStatus.PENDING);
        query.filter(cjr -> cjr.getSource() == ClubJoinRequestSource.PLAYER);
        return query.single();
    }

    public List<ClubJoinRequest> findPendingJoinInvitesByPlayer(int playerId) {
        RepositorySearchQuery<ClubJoinRequest> query = this.createSearchQuery();
        query.filter(cjr -> cjr.getPlayerId() == playerId);
        query.filter(cjr -> cjr.getStatus() == ClubJoinRequestStatus.PENDING);
        query.filter(cjr -> cjr.getSource() == ClubJoinRequestSource.CLUB);
        return query.many();
    }

    public List<ClubJoinRequest> findPendingOrDeniedJoinInvitesByClub(int clubId) {
        RepositorySearchQuery<ClubJoinRequest> query = this.createSearchQuery();
        query.filter(cjr -> cjr.getClubId() == clubId);
        query.filter(cjr -> cjr.getStatus() == ClubJoinRequestStatus.PENDING || cjr.getStatus() == ClubJoinRequestStatus.DENIED);
        query.filter(cjr -> cjr.getSource() == ClubJoinRequestSource.CLUB);
        return query.many();
    }

    public Optional<ClubJoinRequest> findPendingJoinInviteByClubAndPlayer(int clubId, int playerId) {
        RepositorySearchQuery<ClubJoinRequest> query = this.createSearchQuery();
        query.filter(cjr -> cjr.getClubId() == clubId);
        query.filter(cjr -> cjr.getPlayerId() == playerId);
        query.filter(cjr -> cjr.getStatus() == ClubJoinRequestStatus.PENDING);
        query.filter(cjr -> cjr.getSource() == ClubJoinRequestSource.CLUB);
        return query.single();
    }

    public int findJoinInvitesCountSentByClubSinceTime(int clubId, Date time) {
        RepositorySearchQuery<ClubJoinRequest> query = this.createSearchQuery();
        query.filter(cjr -> cjr.getClubId() == clubId);
        query.filter(cjr -> cjr.getTimeStamp().after(time));
        query.filter(cjr -> cjr.getStatus() == ClubJoinRequestStatus.PENDING);
        query.filter(cjr -> cjr.getSource() == ClubJoinRequestSource.CLUB);
        return (int)query.count();
    }
}

