/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.club.joinrequest;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.ClubJoinRequestSource;
import com.equestricraft.common.ClubJoinRequestStatus;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.club.CannotAddClubMemberException;
import com.equestricraft.core.club.CannotSendClubJoinRequestException;
import com.equestricraft.core.club.Club;
import com.equestricraft.core.club.ClubJoinRequestException;
import com.equestricraft.core.club.ClubRepository;
import com.equestricraft.core.club.ClubSettings;
import com.equestricraft.core.club.joinrequest.ClubJoinRequest;
import com.equestricraft.core.club.joinrequest.ClubJoinRequestClubInfo;
import com.equestricraft.core.club.joinrequest.ClubJoinRequestPlayerInfo;
import com.equestricraft.core.club.joinrequest.ClubJoinRequestRepository;
import com.equestricraft.core.club.joinrequest.ClubJoinRequestSession;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.core.player.PlayerTransformer;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class ClubJoinRequestSessionImpl
implements ClubJoinRequestSession {
    @Service
    private ClubJoinRequestRepository clubJoinRequestRepository;
    @Service
    private ClubRepository clubRepository;
    @Service
    private PlayerRepository playerRepository;
    @Service
    private PlayerTransformer playerTransformer;

    @Override
    public void sendJoinRequest(ECPlayer sendingPlayer, int receivingClubId, String message) throws CannotSendClubJoinRequestException {
        this.ensureNoCurrentPendingRequestForSameClub(sendingPlayer, receivingClubId);
        this.ensureJoinRequestsEnabled(receivingClubId);
        this.ensureNotAlreadyInClub(sendingPlayer);
        ClubJoinRequest request = new ClubJoinRequest(0, receivingClubId, sendingPlayer.getId(), new Date(), ClubJoinRequestSource.PLAYER, message, ClubJoinRequestStatus.PENDING, "");
        this.clubJoinRequestRepository.add(request);
    }

    private void ensureNoCurrentPendingRequestForSameClub(ECPlayer player, int clubId) throws CannotSendClubJoinRequestException {
        Optional<ClubJoinRequest> currentPendingRequest = this.clubJoinRequestRepository.findPendingJoinRequestByClubAndPlayer(clubId, player.getId());
        if (currentPendingRequest.isPresent()) {
            throw new CannotSendClubJoinRequestException(I18n.getLabel("club.join-request.already-got-pending-request"));
        }
    }

    private void ensureJoinRequestsEnabled(int clubId) throws CannotSendClubJoinRequestException {
        Club club = (Club)this.clubRepository.findByKey(clubId);
        if (!club.isAllowJoinRequests()) {
            throw new CannotSendClubJoinRequestException(I18n.getLabel("club.join-request.club-disabled-requests"));
        }
    }

    private void ensureNotAlreadyInClub(ECPlayer player) throws CannotSendClubJoinRequestException {
        if (player.getClub().getClub().isPresent()) {
            throw new CannotSendClubJoinRequestException(I18n.getLabel("club.member.already-in-a-club"));
        }
    }

    @Override
    public List<ClubJoinRequestPlayerInfo> retrievePendingRequestsForClub(int clubId) {
        List<ClubJoinRequest> requests = this.clubJoinRequestRepository.findPendingJoinRequestsByClub(clubId);
        return requests.stream().map(this::buildRequestPlayerInfo).toList();
    }

    private ClubJoinRequestPlayerInfo buildRequestPlayerInfo(ClubJoinRequest clubJoinRequest) {
        CorePlayer player = (CorePlayer)this.playerRepository.findByKey(clubJoinRequest.getPlayerId());
        return new ClubJoinRequestPlayerInfo(this.playerTransformer.toSimple(player), DateUtils.hoursSince(clubJoinRequest.getTimeStamp()), clubJoinRequest.getMessage());
    }

    @Override
    public List<ClubJoinRequestClubInfo> retrievePendingOrDeniedRequestsForPlayer(ECPlayer player) {
        List<ClubJoinRequest> requests = this.clubJoinRequestRepository.findPendingOrDeniedJoinRequestsByPlayer(player.getId());
        return requests.stream().map(this::buildRequestClubInfo).toList();
    }

    private ClubJoinRequestClubInfo buildRequestClubInfo(ClubJoinRequest clubJoinRequest) {
        Club club = (Club)this.clubRepository.findByKey(clubJoinRequest.getClubId());
        return new ClubJoinRequestClubInfo(club.getId(), club.getName(), DateUtils.hoursSince(clubJoinRequest.getTimeStamp()), clubJoinRequest.getMessage(), clubJoinRequest.getStatus(), clubJoinRequest.getStatusMessage());
    }

    @Override
    public void approveRequest(Club club, ECPlayer player) throws ClubJoinRequestException {
        ClubJoinRequest request = this.clubJoinRequestRepository.findPendingJoinRequestByClubAndPlayer(club.getId(), player.getId()).orElseThrow(() -> new ClubJoinRequestException("Cannot find player"));
        try {
            player.getClub().addToClub(club);
            request.setStatus(ClubJoinRequestStatus.APPROVED);
            request.save();
            player.notify(I18n.getLabel("club.join-requests.your-request-accepted", club.getName()));
        }
        catch (CannotAddClubMemberException ex) {
            throw new ClubJoinRequestException(ex.getMessage());
        }
    }

    @Override
    public void denyRequest(Club club, ECPlayer player, String reason) throws ClubJoinRequestException {
        ClubJoinRequest request = this.clubJoinRequestRepository.findPendingJoinRequestByClubAndPlayer(club.getId(), player.getId()).orElseThrow(() -> new ClubJoinRequestException("Cannot find player"));
        request.setStatus(ClubJoinRequestStatus.DENIED);
        request.setStatusMessage(reason);
        request.save();
        player.notify(I18n.getLabel("club.join-requests.your-request-denied", club.getName()));
    }

    @Override
    public void sendJoinInvite(Club club, ECPlayer receivingPlayer, String message) throws CannotSendClubJoinRequestException {
        Optional<ClubJoinRequest> existingInvite = this.clubJoinRequestRepository.findPendingJoinInviteByClubAndPlayer(club.getId(), receivingPlayer.getId());
        if (existingInvite.isPresent()) {
            throw new CannotSendClubJoinRequestException(I18n.getLabel("club.join-invite.already-got-pending-invite"));
        }
        this.ensureClubNotAtLimit(club.getId());
        ClubJoinRequest invite = new ClubJoinRequest(0, club.getId(), receivingPlayer.getId(), new Date(), ClubJoinRequestSource.CLUB, message, ClubJoinRequestStatus.PENDING, "");
        this.clubJoinRequestRepository.add(invite);
        receivingPlayer.notify(I18n.getLabel("club.join-invite.received", club.getName()));
    }

    private void ensureClubNotAtLimit(int clubId) throws CannotSendClubJoinRequestException {
        int maximumPerWeek;
        Date date = DateUtils.futureDaysOffset(-7);
        int invitesSent = this.clubJoinRequestRepository.findJoinInvitesCountSentByClubSinceTime(clubId, date);
        if (invitesSent >= (maximumPerWeek = ClubSettings.getInvitesWeeklyMaximum().intValue())) {
            throw new CannotSendClubJoinRequestException(I18n.getLabel("club.join-invite.limit-reached"));
        }
    }

    @Override
    public List<ClubJoinRequestClubInfo> retrievePendingInvitesForPlayer(ECPlayer player) {
        List<ClubJoinRequest> invites = this.clubJoinRequestRepository.findPendingJoinInvitesByPlayer(player.getId());
        return invites.stream().map(this::buildRequestClubInfo).toList();
    }

    @Override
    public List<ClubJoinRequestPlayerInfo> retrievePendingOrDeniedInvitesForClub(int clubId) {
        List<ClubJoinRequest> invites = this.clubJoinRequestRepository.findPendingOrDeniedJoinInvitesByClub(clubId);
        return invites.stream().map(this::buildRequestPlayerInfo).toList();
    }

    @Override
    public void acceptInvite(ECPlayer player, int clubId) throws ClubJoinRequestException {
        ClubJoinRequest invite = this.clubJoinRequestRepository.findPendingJoinInviteByClubAndPlayer(clubId, player.getId()).orElseThrow(() -> new ClubJoinRequestException("Cannot find player"));
        Club club = (Club)this.clubRepository.findByKey(clubId);
        try {
            player.getClub().addToClub(club);
            invite.setStatus(ClubJoinRequestStatus.APPROVED);
            invite.save();
        }
        catch (CannotAddClubMemberException ex) {
            throw new ClubJoinRequestException(ex.getMessage());
        }
    }

    @Override
    public void denyInvite(ECPlayer player, int clubId, String reason) throws ClubJoinRequestException {
        ClubJoinRequest invite = this.clubJoinRequestRepository.findPendingJoinInviteByClubAndPlayer(clubId, player.getId()).orElseThrow(() -> new ClubJoinRequestException("Cannot find player"));
        invite.setStatus(ClubJoinRequestStatus.DENIED);
        invite.setStatusMessage(reason);
        invite.save();
    }
}

