/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.club.member;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.club.member.ClubMember;
import java.sql.Date;
import java.util.List;

public class ClubMemberDatabase
implements RepositoryDatasource<ClubMember, Integer> {
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";
    private static final String COLUMN_CLUB_ID = "CLUB_ID";
    private static final String COLUMN_CLUB_RANK_ID = "CLUB_RANK_ID";
    private static final String COLUMN_SINCE = "SINCE";

    @Override
    public void create(ClubMember clubMember) {
        Query.insertInto("CLUB_MEMBER").columns(QueryColumn.column(COLUMN_PLAYER_ID, clubMember.getPlayerId()), QueryColumn.column(COLUMN_CLUB_ID, clubMember.getClubId()), QueryColumn.column(COLUMN_CLUB_RANK_ID, clubMember.getClubRankId()), QueryColumn.column(COLUMN_SINCE, clubMember.getSince())).execute();
    }

    @Override
    public List<ClubMember> retrieveAll() {
        return Query.selectAllFrom("CLUB_MEMBER").getList(this::getClubMemberFromResultRow);
    }

    private ClubMember getClubMemberFromResultRow(ResultRow row) {
        int playerId = row.getInt(COLUMN_PLAYER_ID);
        int clubId = row.getInt(COLUMN_CLUB_ID);
        Integer clubRankId = row.getNullableInt(COLUMN_CLUB_RANK_ID);
        Date since = row.getNullableDate(COLUMN_SINCE);
        return new ClubMember(playerId, clubId, clubRankId, since);
    }

    @Override
    public void update(ClubMember clubMember) {
        Query.update("CLUB_MEMBER").set(QueryColumn.column(COLUMN_CLUB_RANK_ID, clubMember.getClubRankId())).where(QueryColumn.column(COLUMN_PLAYER_ID, clubMember.getPlayerId())).execute();
    }
}

