/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.club.member;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.ObjectUtils;
import com.equestricraft.core.club.CannotAddClubMemberException;
import com.equestricraft.core.club.Club;
import com.equestricraft.core.club.ClubRepository;
import com.equestricraft.core.club.PlayerNotInClubException;
import com.equestricraft.core.club.member.ClubMember;
import com.equestricraft.core.club.member.ClubMemberInfo;
import com.equestricraft.core.club.member.ClubMemberRepository;
import com.equestricraft.core.club.member.ClubMemberSession;
import com.equestricraft.core.club.rank.ClubRank;
import com.equestricraft.core.club.rank.ClubRankRepository;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.core.player.PlayerTransformer;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ClubMemberSessionImpl
implements ClubMemberSession {
    @Service
    private ClubMemberRepository clubMemberRepository;
    @Service
    private ClubRankRepository clubRankRepository;
    @Service
    private ClubRepository clubRepository;
    @Service
    private PlayerRepository playerRepository;
    @Service
    private PlayerTransformer playerTransformer;

    @Override
    public void addClubMember(ECPlayer player, int clubId) throws CannotAddClubMemberException {
        this.ensurePlayerNotAlreadyInClub(player);
        Optional<ClubRank> defaultRank = this.clubRankRepository.findDefaultRankByClub(clubId);
        ClubMember clubMember = new ClubMember(player.getId(), clubId, defaultRank.map(ClubRank::getId).orElse(null), new Date());
        this.clubMemberRepository.add(clubMember);
    }

    private void ensurePlayerNotAlreadyInClub(ECPlayer player) throws CannotAddClubMemberException {
        if (player.getClub().getClub().isPresent()) {
            throw new CannotAddClubMemberException(I18n.getLabel("club.member.already-in-a-club"));
        }
    }

    @Override
    public void removeClubMember(ECPlayer player, int clubId) throws PlayerNotInClubException {
        ClubMember membership = this.clubMemberRepository.findClubMemberByPlayer(player.getId()).orElseThrow(() -> new PlayerNotInClubException(I18n.getLabel("club.member.not-in-this-club")));
        if (membership.getClubId() != clubId) {
            throw new PlayerNotInClubException(I18n.getLabel("club.member.not-in-this-club"));
        }
        this.clubMemberRepository.removeByKey(player.getId());
        Club club = (Club)this.clubRepository.findByKey(clubId);
        player.notify(I18n.getLabel("club.kick-member.you-kicked", club.getName()));
    }

    @Override
    public void setClubMembersRank(ECPlayer player, int clubId, int rankId) throws PlayerNotInClubException {
        ClubMember membership = this.clubMemberRepository.findClubMemberByPlayer(player.getId()).filter(m -> m.getClubId() == clubId).orElseThrow(() -> new PlayerNotInClubException(I18n.getLabel("club.member.not-in-this-club")));
        membership.setClubRankId(rankId);
        membership.save();
    }

    @Override
    public Optional<Club> getPlayersClub(ECPlayer player) {
        Optional<Club> ownersClub = this.clubRepository.findNonDisbandedClubByOwner(player.getId());
        if (ownersClub.isPresent()) {
            return ownersClub;
        }
        Optional<ClubMember> member = this.clubMemberRepository.findClubMemberByPlayer(player.getId());
        return member.flatMap(cm -> this.clubRepository.findByKeyIfExists(cm.getClubId()));
    }

    @Override
    public Optional<ClubRank> getPlayersClubRank(ECPlayer player) {
        Optional<ClubMember> member = this.clubMemberRepository.findClubMemberByPlayer(player.getId());
        return member.flatMap(cm -> this.clubRankRepository.findByKeyIfExists(cm.getClubRankId()));
    }

    @Override
    public int getMemberCountAtTime(int clubId, Date time) {
        List<ClubMember> members = this.clubMemberRepository.findClubMembersByClub(clubId);
        return (int)members.stream().filter(cm -> cm.getSince().after(time)).count();
    }

    @Override
    public List<ClubMemberInfo> retrieveAllClubsMembers(Club club) {
        List<ClubMember> clubMembers = this.clubMemberRepository.findClubMembersByClub(club.getId());
        List<ClubRank> clubsRanks = this.clubRankRepository.findClubRanksByClub(club.getId());
        List members = clubMembers.stream().map(cm -> this.buildClubMemberInfo((ClubMember)cm, clubsRanks)).collect(Collectors.toList());
        members.add(this.getOwnerMemberInfo(club));
        return Collections.unmodifiableList(members);
    }

    private ClubMemberInfo buildClubMemberInfo(ClubMember cm, List<ClubRank> clubRanks) {
        CorePlayer player = (CorePlayer)this.playerRepository.findByKey(cm.getPlayerId());
        ClubRank rank = cm.getClubRankId() != null ? clubRanks.stream().filter(cr -> cr.getId() == cm.getClubRankId().intValue()).findFirst().orElseThrow() : null;
        return new ClubMemberInfo(this.playerTransformer.toSimple(player), ObjectUtils.nullable(rank, ClubRank::getId), ObjectUtils.nullable(rank, ClubRank::getName), ObjectUtils.nullable(rank, ClubRank::getPermissionLevel), cm.getSince(), false);
    }

    private ClubMemberInfo getOwnerMemberInfo(Club club) {
        CorePlayer owner = club.getOwner().getCorePlayer();
        return new ClubMemberInfo(this.playerTransformer.toSimple(owner), null, null, null, club.getCreatedDate(), true);
    }
}

