/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.club.rank;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.club.ClubPermission;

public enum ClubPermissionLevel {
    MEMBER("club.rank.permission-level.member.label", "club.rank.permission-level.member.description", new ClubPermission[0]),
    MODERATOR("club.rank.permission-level.moderator.label", "club.rank.permission-level.moderator.description", ClubPermission.MANAGE_JOIN_REQUESTS, ClubPermission.SEND_INVITES),
    ADMINISTRATOR("club.rank.permission-level.administrator.label", "club.rank.permission-level.administrator.description", ClubPermission.MANAGE_JOIN_REQUESTS, ClubPermission.SEND_INVITES, ClubPermission.MANAGE_MEMBERS, ClubPermission.EDIT_DETAILS);

    private final String nameResourceKey;
    private final String descriptionResourceKey;
    private final ClubPermission[] permissions;

    private ClubPermissionLevel(String nameResourceKey, String descriptionResourceKey, ClubPermission ... permissions) {
        this.nameResourceKey = nameResourceKey;
        this.descriptionResourceKey = descriptionResourceKey;
        this.permissions = permissions;
    }

    public String getNameResourceKey() {
        return this.nameResourceKey;
    }

    public String getTranslatedName() {
        return I18n.getLabel(this.getNameResourceKey());
    }

    public String getDescriptionResourceKey() {
        return this.descriptionResourceKey;
    }

    public String getTranslatedDescription() {
        return I18n.getLabel(this.getDescriptionResourceKey());
    }

    public boolean hasPermission(ClubPermission permission) {
        for (ClubPermission p : this.permissions) {
            if (p != permission) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyPermission() {
        return this.permissions.length > 0;
    }
}

