/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.club.rank;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.club.rank.ClubPermissionLevel;
import com.equestricraft.core.club.rank.ClubRank;
import java.util.List;

public class ClubRankDatabase
implements RepositoryDatasource<ClubRank, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_CLUB_ID = "CLUB_ID";
    private static final String COLUMN_NAME = "NAME";
    private static final String COLUMN_PERMISSION_LEVEL = "PERMISSION_LEVEL";
    private static final String COLUMN_DEFAULT_RANK = "DEFAULT_RANK";

    @Override
    public void create(ClubRank clubRank) {
        Query.insertInto("CLUB_RANK").columns(QueryColumn.column(COLUMN_CLUB_ID, clubRank.getClubId()), QueryColumn.column(COLUMN_NAME, clubRank.getName()), QueryColumn.column(COLUMN_PERMISSION_LEVEL, clubRank.getPermissionLevel()), QueryColumn.column(COLUMN_DEFAULT_RANK, clubRank.isDefaultRank())).executeGetGeneratedKey(clubRank::setId);
    }

    @Override
    public List<ClubRank> retrieveAll() {
        return Query.selectAllFrom("CLUB_RANK").getList(this::getClubRankFromResultRow);
    }

    private ClubRank getClubRankFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        int clubId = row.getInt(COLUMN_CLUB_ID);
        String name = row.getString(COLUMN_NAME);
        ClubPermissionLevel permissionLevel = row.getNullableEnum(COLUMN_PERMISSION_LEVEL, ClubPermissionLevel.class);
        boolean defaultRank = row.getBoolean(COLUMN_DEFAULT_RANK);
        return new ClubRank(id, clubId, name, permissionLevel, defaultRank);
    }

    @Override
    public void update(ClubRank clubRank) {
        Query.update("CLUB_RANK").set(QueryColumn.column(COLUMN_NAME, clubRank.getName()), QueryColumn.column(COLUMN_PERMISSION_LEVEL, clubRank.getPermissionLevel()), QueryColumn.column(COLUMN_DEFAULT_RANK, clubRank.isDefaultRank()), QueryColumn.column(COLUMN_CLUB_ID, clubRank.getClubId())).where(QueryColumn.column(COLUMN_ID, clubRank.getId())).execute();
    }
}

