/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.club.rank;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.base.repository.RepositorySearchQuery;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.club.rank.ClubRank;
import com.equestricraft.core.club.rank.ClubRankDatabase;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class ClubRankRepository
extends Repository<ClubRank, Integer> {
    @Service
    private ClubRankDatabase clubRankDatabase;

    @Override
    protected RepositoryDatasource<ClubRank, Integer> getDatasource() {
        return this.clubRankDatabase;
    }

    @Override
    protected Function<ClubRank, Object> getIndexFunction() {
        return ClubRank::getClubId;
    }

    public List<ClubRank> findClubRanksByClub(int clubId) {
        return this.findListByIndexKey(clubId);
    }

    public Optional<ClubRank> findDefaultRankByClub(int clubId) {
        RepositorySearchQuery<ClubRank> query = this.createSearchQuery();
        query.filter(cr -> cr.getClubId() == clubId);
        query.filter(ClubRank::isDefaultRank);
        return query.single();
    }
}

