/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.club.rank;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.club.Club;
import com.equestricraft.core.club.ClubRankException;
import com.equestricraft.core.club.ClubSettings;
import com.equestricraft.core.club.member.ClubMemberSession;
import com.equestricraft.core.club.rank.ClubPermissionLevel;
import com.equestricraft.core.club.rank.ClubRank;
import com.equestricraft.core.club.rank.ClubRankInfo;
import com.equestricraft.core.club.rank.ClubRankRepository;
import com.equestricraft.core.club.rank.ClubRankSession;
import java.util.Date;
import java.util.List;

public class ClubRankSessionImpl
implements ClubRankSession {
    @Service
    private ClubRankRepository clubRankRepository;
    @Service
    private ClubMemberSession clubMemberSession;

    @Override
    public void updateClubRankName(int rankId, String newName) {
        ClubRank clubRank = (ClubRank)this.clubRankRepository.findByKey(rankId);
        clubRank.setName(newName);
    }

    @Override
    public void updateClubRankPermissionLevel(int rankId, ClubPermissionLevel permissionLevel) {
        ClubRank clubRank = (ClubRank)this.clubRankRepository.findByKey(rankId);
        clubRank.setPermissionLevel(permissionLevel);
    }

    @Override
    public void setClubsDefaultRank(int clubId, int rankId) {
        ClubRank clubRank = (ClubRank)this.clubRankRepository.findByKey(rankId);
        if (clubRank.getClubId() != clubId) {
            throw new IllegalArgumentException("Club rank is not for that club!");
        }
        List<ClubRank> clubRanks = this.clubRankRepository.findClubRanksByClub(clubId);
        clubRanks.forEach(cr -> cr.setDefaultRank(false));
        clubRank.setDefaultRank(true);
    }

    @Override
    public void createClubRank(Club club, String rankName, ClubPermissionLevel permissionLevel) throws ClubRankException {
        List<ClubRank> existingRanks = this.clubRankRepository.findClubRanksByClub(club.getId());
        this.ensureClubIsAllowedExtraRanks(club, existingRanks);
        ClubRank clubRank = new ClubRank(0, club.getId(), rankName, permissionLevel, existingRanks.isEmpty());
        this.clubRankRepository.add(clubRank);
    }

    private void ensureClubIsAllowedExtraRanks(Club club, List<ClubRank> currentRanks) throws ClubRankException {
        int limit;
        int totalRanks = currentRanks.size();
        if (totalRanks >= (limit = this.getClubsRanksLimit(club))) {
            throw new ClubRankException(I18n.getLabel("club.rank.limit-reached"));
        }
    }

    private int getClubsRanksLimit(Club club) {
        int baseRanks = ClubSettings.getRankDefaultLimit();
        int additionalRanks = this.getAdditionalRanksForClubSize(club);
        int clubPlusExtraRanks = club.hasClubPlus() ? ClubSettings.getPlusExtraRanks() : 0;
        return baseRanks + additionalRanks + clubPlusExtraRanks;
    }

    private int getAdditionalRanksForClubSize(Club club) {
        int daysCutOff = ClubSettings.getRankDaysCutoff();
        Date cutOffTime = DateUtils.futureDaysOffset(-daysCutOff);
        int memberCount = this.clubMemberSession.getMemberCountAtTime(club.getId(), cutOffTime);
        int membersPerRank = ClubSettings.getRankMemberPerRank();
        return Math.floorDiv(memberCount, membersPerRank);
    }

    @Override
    public List<ClubRankInfo> retrieveAllClubsRanks(int clubId) {
        List<ClubRank> ranks = this.clubRankRepository.findClubRanksByClub(clubId);
        return ranks.stream().map(this::buildClubRankInfo).toList();
    }

    private ClubRankInfo buildClubRankInfo(ClubRank r) {
        return new ClubRankInfo(r.getId(), r.getName(), r.getPermissionLevel(), r.isDefaultRank());
    }
}

