/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.collectable;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.common.coordinate.BlockCoordinate;
import java.util.Objects;

public class Collectable
implements RepositoryEntity<Integer> {
    private final int id;
    private final String name;
    private final int groupId;
    private final Integer coolDownHours;
    private final BlockCoordinate blockCoordinate;
    private final String conditionScript;
    private final int xpReward;
    private final double moneyReward;
    private final Integer itemId;
    private final Integer itemQuantity;

    public Collectable(int id, String name, int groupId, Integer coolDownHours, BlockCoordinate blockCoordinate, String conditionScript, int xpReward, double moneyReward, Integer itemId, Integer itemQuantity) {
        this.id = id;
        this.name = name;
        this.groupId = groupId;
        this.coolDownHours = coolDownHours;
        this.blockCoordinate = blockCoordinate;
        this.conditionScript = conditionScript;
        this.xpReward = xpReward;
        this.moneyReward = moneyReward;
        this.itemId = itemId;
        this.itemQuantity = itemQuantity;
    }

    @Override
    public Integer getKey() {
        return this.getId();
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public Integer getCoolDownHours() {
        return this.coolDownHours;
    }

    public BlockCoordinate getBlockCoordinate() {
        return this.blockCoordinate;
    }

    public boolean hasLocation() {
        return this.blockCoordinate != null;
    }

    public String getConditionScript() {
        return this.conditionScript;
    }

    public int getXpReward() {
        return this.xpReward;
    }

    public double getMoneyReward() {
        return this.moneyReward;
    }

    public Integer getItemId() {
        return this.itemId;
    }

    public Integer getItemQuantity() {
        return this.itemQuantity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Collectable that = (Collectable)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.name;
    }
}

