/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.collectable;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.common.coordinate.BlockCoordinate;
import com.equestricraft.core.collectable.Collectable;
import java.util.List;

public class CollectableDatabase
implements RepositoryDatasource<Collectable, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_NAME = "NAME";
    private static final String COLUMN_GROUP_ID = "GROUP_ID";
    private static final String COLUMN_COOL_DOWN_HOURS = "COOL_DOWN_HOURS";
    private static final String COLUMN_BLOCK_COORDINATE = "BLOCK_COORDINATE";
    private static final String COLUMN_CONDITION_SCRIPT = "CONDITION_SCRIPT";
    private static final String COLUMN_XP_REWARD = "XP_REWARD";
    private static final String COLUMN_MONEY_REWARD = "MONEY_REWARD";
    private static final String COLUMN_ITEM_ID = "ITEM_ID";
    private static final String COLUMN_ITEM_QUANTITY = "ITEM_QUANTITY";
    private static final String COLUMN_PUBLISHED = "PUBLISHED";

    @Override
    public List<Collectable> retrieveAll() {
        return Query.selectAllFrom("COLLECTABLE").where(QueryColumn.column(COLUMN_PUBLISHED, true)).getList(this::getFromResultRow);
    }

    private Collectable getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        String name = row.getString(COLUMN_NAME);
        int groupId = row.getInt(COLUMN_GROUP_ID);
        Integer coolDownHours = row.getNullableInt(COLUMN_COOL_DOWN_HOURS);
        BlockCoordinate blockCoordinate = row.getNullableBlockCoordinate(COLUMN_BLOCK_COORDINATE);
        String conditionScript = row.getNullableString(COLUMN_CONDITION_SCRIPT);
        int xpReward = row.getInt(COLUMN_XP_REWARD);
        double moneyReward = row.getDouble(COLUMN_MONEY_REWARD);
        Integer itemId = row.getNullableInt(COLUMN_ITEM_ID);
        Integer itemQuantity = row.getNullableInt(COLUMN_ITEM_QUANTITY);
        return new Collectable(id, name, groupId, coolDownHours, blockCoordinate, conditionScript, xpReward, moneyReward, itemId, itemQuantity);
    }
}

