/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.collectable;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.base.repository.RepositorySearchQuery;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.coordinate.BlockCoordinate;
import com.equestricraft.core.collectable.Collectable;
import com.equestricraft.core.collectable.CollectableDatabase;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class CollectableRepository
extends Repository<Collectable, Integer> {
    @Service
    private CollectableDatabase collectableDatabase;

    @Override
    protected RepositoryDatasource<Collectable, Integer> getDatasource() {
        return this.collectableDatabase;
    }

    @Override
    protected Function<Collectable, Object> getIndexFunction() {
        return Collectable::getGroupId;
    }

    public Optional<Collectable> findCollectableAtLocation(BlockCoordinate blockCoordinate) {
        RepositorySearchQuery<Collectable> searchQuery = this.createSearchQuery();
        searchQuery.filter(Collectable::hasLocation);
        searchQuery.filter(c -> c.getBlockCoordinate().equals(blockCoordinate));
        return searchQuery.single();
    }

    public List<Collectable> findCollectablesByGroup(int groupId) {
        return this.findListByIndexKey(groupId);
    }
}

