/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.collectable;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.coordinate.BlockCoordinate;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.collectable.CannotGetCollectableException;
import com.equestricraft.core.collectable.Collectable;
import com.equestricraft.core.collectable.CollectableGroupPlayerInfo;
import com.equestricraft.core.collectable.CollectablePlayerInfo;
import com.equestricraft.core.collectable.CollectableRepository;
import com.equestricraft.core.collectable.CollectableSession;
import com.equestricraft.core.collectable.FoundCollectableResponse;
import com.equestricraft.core.collectable.group.CollectableGroup;
import com.equestricraft.core.collectable.group.CollectableGroupRepository;
import com.equestricraft.core.collectable.log.CollectableLogSession;
import com.equestricraft.core.config.APIConfigDtoImpl;
import com.equestricraft.core.global.APIGlobalDtoImpl;
import com.equestricraft.core.item.ECItem;
import com.equestricraft.core.item.ECItemRepository;
import com.equestricraft.core.player.APIPlayerDtoImpl;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.groovy.GroovyException;
import com.equestricraft.groovy.executor.GroovyRuleScriptExecutor;
import com.equestricraft.groovy.executor.RuleScriptResponse;
import com.equestricraft.logging.Log;
import java.util.List;
import java.util.Optional;

public class CollectableSessionImpl
implements CollectableSession {
    @Service
    private CollectableRepository collectableRepository;
    @Service
    private CollectableLogSession collectableLogSession;
    @Service
    private CollectableGroupRepository collectableGroupRepository;
    @Service
    private ECItemRepository ecItemRepository;
    private static final Log log = Log.getLogger(CollectableSessionImpl.class.getName());

    @Override
    public Optional<FoundCollectableResponse> processCollectableAtLocation(ECPlayer player, BlockCoordinate blockCoordinate) throws CannotGetCollectableException {
        Optional<CollectableInfo> collectable = this.findCollectableInfoForLocation(blockCoordinate);
        if (collectable.isPresent()) {
            return Optional.of(this.processCollectableForPlayer(player, collectable.get()));
        }
        return Optional.empty();
    }

    private Optional<CollectableInfo> findCollectableInfoForLocation(BlockCoordinate blockCoordinate) {
        Optional<Collectable> collectable = this.collectableRepository.findCollectableAtLocation(blockCoordinate);
        return collectable.map(this::buildCollectableInfo);
    }

    private CollectableInfo buildCollectableInfo(Collectable collectable) {
        CollectableGroup group = (CollectableGroup)this.collectableGroupRepository.findByKey(collectable.getGroupId());
        return new CollectableInfo(collectable, group);
    }

    @Override
    public FoundCollectableResponse processCollectable(ECPlayer player, Collectable collectable) throws CannotGetCollectableException {
        CollectableInfo collectableInfo = this.buildCollectableInfo(collectable);
        return this.processCollectableForPlayer(player, collectableInfo);
    }

    private FoundCollectableResponse processCollectableForPlayer(ECPlayer player, CollectableInfo collectable) throws CannotGetCollectableException {
        this.ensureCanBeFoundNow(player, collectable.collectable());
        this.processConditionScript(collectable.collectable(), player);
        this.processRewards(collectable.collectable(), player);
        this.collectableLogSession.logCollectableAsFound(collectable.collectable(), player);
        Optional<String> completedGroupName = this.checkGroupCompletion(player, collectable.group());
        return FoundCollectableResponse.create(completedGroupName.orElse(null));
    }

    private void ensureCanBeFoundNow(ECPlayer player, Collectable collectable) throws CannotGetCollectableException {
        Optional<Long> mostRecent = this.collectableLogSession.findMostRecentTimePlayerFoundCollectable(player, collectable.getId());
        if (mostRecent.isPresent()) {
            if (collectable.getCoolDownHours() == null) {
                throw new CannotGetCollectableException(I18n.getLabel("collectable.already-found.prompt.message"), I18n.getLabel("collectable.already-found.prompt.title"));
            }
            int hoursSinceFound = DateUtils.hoursSince(mostRecent.get());
            if (hoursSinceFound < collectable.getCoolDownHours()) {
                throw new CannotGetCollectableException(I18n.getLabel("collectable.must-wait.prompt.message"), I18n.getLabel("collectable.must-wait.prompt.title"));
            }
        }
    }

    private void processConditionScript(Collectable collectable, ECPlayer player) throws CannotGetCollectableException {
        if (collectable.getConditionScript() == null) {
            return;
        }
        RuleScriptResponse response = this.executeConditionScript(collectable, player);
        if (Boolean.FALSE.equals(response.success())) {
            throw new CannotGetCollectableException(response.promptRequest().getMessage(), response.promptRequest().getTitle());
        }
    }

    private RuleScriptResponse executeConditionScript(Collectable collectable, ECPlayer player) throws CannotGetCollectableException {
        try {
            APIPlayerDtoImpl playerDto = new APIPlayerDtoImpl(player.getCorePlayer());
            return ((GroovyRuleScriptExecutor)((GroovyRuleScriptExecutor)((GroovyRuleScriptExecutor)GroovyRuleScriptExecutor.start(collectable.getConditionScript()).withPlayer(playerDto)).withGlobal(new APIGlobalDtoImpl())).withConfig(new APIConfigDtoImpl())).execute().result();
        }
        catch (GroovyException ex) {
            log.error(String.format("Error running condition script for collectable %s", collectable.getId()), ex);
            throw new CannotGetCollectableException("Error performing condition check", "Error");
        }
    }

    private void processRewards(Collectable collectable, ECPlayer player) {
        if (collectable.getXpReward() > 0) {
            player.getProgression().hasXp(collectable.getXpReward());
        }
        if (collectable.getMoneyReward() > 0.0) {
            player.getEconomy().deposit(collectable.getMoneyReward(), collectable.getName(), "Collectable");
        }
        if (collectable.getItemId() != null) {
            ECItem ecItem = (ECItem)this.ecItemRepository.findByKey(collectable.getItemId());
            player.getInventory().addItem(ecItem, collectable.getItemQuantity());
        }
    }

    private Optional<String> checkGroupCompletion(ECPlayer player, CollectableGroup collectableGroup) {
        if (this.hasPlayerCompletedGroup(player, collectableGroup)) {
            if (collectableGroup.getXpReward() > 0) {
                player.getProgression().giveXp(collectableGroup.getXpReward());
            }
            if (collectableGroup.getMoneyReward() > 0.0) {
                player.getEconomy().deposit(collectableGroup.getMoneyReward(), collectableGroup.getName(), "Collectable Group");
            }
            return Optional.of(collectableGroup.getName());
        }
        return Optional.empty();
    }

    @Override
    public boolean hasPlayerCompletedGroup(ECPlayer player, CollectableGroup collectableGroup) {
        List<Collectable> collectablesInGroup = this.collectableRepository.findCollectablesByGroup(collectableGroup.getId());
        List<Integer> collectableIds = collectablesInGroup.stream().map(Collectable::getGroupId).toList();
        return this.collectableLogSession.hasPlayerFoundCollectables(player, collectableIds);
    }

    @Override
    public CollectableGroupPlayerInfo retrieveGroupInfoForPlayer(int groupId, ECPlayer player) {
        CollectableGroup group = (CollectableGroup)this.collectableGroupRepository.findByKey(groupId);
        List<Collectable> collectablesInGroup = this.collectableRepository.findCollectablesByGroup(groupId);
        List<CollectablePlayerInfo> playerInfoList = collectablesInGroup.stream().map(c -> this.buildCollectablePlayerInfo((Collectable)c, player)).toList();
        double percentage = this.calculateCompletionPercentage(playerInfoList);
        return new CollectableGroupPlayerInfo(group.getId(), group.getName(), percentage, playerInfoList);
    }

    @Override
    public List<Collectable> retrieveAllFoundCollectables(ECPlayer player) {
        List<Integer> collectableIds = this.collectableLogSession.getIdsOfFoundCollectablesForPlayer(player);
        return this.collectableRepository.findByKeys(collectableIds);
    }

    private CollectablePlayerInfo buildCollectablePlayerInfo(Collectable collectable, ECPlayer player) {
        boolean found = this.collectableLogSession.hasPlayerFoundCollectable(player, collectable.getId());
        return new CollectablePlayerInfo(collectable.getId(), collectable.getName(), found);
    }

    private double calculateCompletionPercentage(List<CollectablePlayerInfo> playerInfoList) {
        int total = playerInfoList.size();
        long completed = playerInfoList.stream().filter(CollectablePlayerInfo::found).count();
        return (double)completed / (double)total * 100.0;
    }

    private record CollectableInfo(Collectable collectable, CollectableGroup group) {
    }
}

