/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.collectable.log;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.collectable.log.CollectableLog;
import java.util.List;

public class CollectableLogDatabase
implements RepositoryDatasource<CollectableLog, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_COLLECTABLE_ID = "COLLECTABLE_ID";
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";
    private static final String COLUMN_TIME_STAMP = "TIME_STAMP";

    @Override
    public void create(CollectableLog collectableLog) {
        Query.insertInto("COLLECTABLE_LOG").columns(QueryColumn.column(COLUMN_COLLECTABLE_ID, collectableLog.getCollectableId()), QueryColumn.column(COLUMN_PLAYER_ID, collectableLog.getPlayerId()), QueryColumn.column(COLUMN_TIME_STAMP, collectableLog.getTimeStamp())).executeGetGeneratedKey(collectableLog::setId);
    }

    @Override
    public List<CollectableLog> retrieveAll() {
        return Query.selectAllFrom("COLLECTABLE_LOG").getList(this::getFromResultRow);
    }

    private CollectableLog getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        int collectableId = row.getInt(COLUMN_COLLECTABLE_ID);
        int playerId = row.getInt(COLUMN_PLAYER_ID);
        long timeStamp = row.getLong(COLUMN_TIME_STAMP);
        return new CollectableLog(id, collectableId, playerId, timeStamp);
    }
}

