/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.collectable.log;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.base.repository.RepositorySearchQuery;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.collectable.log.CollectableLog;
import com.equestricraft.core.collectable.log.CollectableLogDatabase;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class CollectableLogRepository
extends Repository<CollectableLog, Integer> {
    @Service
    private CollectableLogDatabase collectableLogDatabase;

    @Override
    protected RepositoryDatasource<CollectableLog, Integer> getDatasource() {
        return this.collectableLogDatabase;
    }

    @Override
    protected Function<CollectableLog, Object> getIndexFunction() {
        return CollectableLog::getPlayerId;
    }

    public Optional<CollectableLog> findMostRecentLogForPlayerAndCollectable(int playerId, int collectableId) {
        RepositorySearchQuery<CollectableLog> searchQuery = this.createSearchQuery();
        searchQuery.mappedEquals(CollectableLog::getPlayerId, playerId);
        searchQuery.mappedEquals(CollectableLog::getCollectableId, collectableId);
        searchQuery.sortReverse(CollectableLog::getTimeStamp);
        return searchQuery.single();
    }

    public Optional<CollectableLog> findFirstLogForPlayerAndCollectable(int playerId, int collectableId) {
        RepositorySearchQuery<CollectableLog> searchQuery = this.createSearchQuery();
        searchQuery.mappedEquals(CollectableLog::getPlayerId, playerId);
        searchQuery.mappedEquals(CollectableLog::getCollectableId, collectableId);
        searchQuery.sort(CollectableLog::getTimeStamp);
        return searchQuery.single();
    }

    public List<CollectableLog> findLogsByPlayerAndCollectable(int playerId, int collectableId) {
        return this.findListByPredicates(l -> l.getPlayerId() == playerId, l -> l.getCollectableId() == collectableId);
    }

    public List<CollectableLog> findLogsByPlayer(int playerId) {
        return this.findListByIndexKey(playerId);
    }
}

