/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.collectable.log;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.collectable.Collectable;
import com.equestricraft.core.collectable.log.CollectableLog;
import com.equestricraft.core.collectable.log.CollectableLogRepository;
import com.equestricraft.core.collectable.log.CollectableLogSession;
import com.equestricraft.core.player.ECPlayer;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class CollectableLogSessionImpl
implements CollectableLogSession {
    @Service
    private CollectableLogRepository collectableLogRepository;

    @Override
    public void logCollectableAsFound(Collectable collectable, ECPlayer player) {
        long timeStamp = System.currentTimeMillis();
        CollectableLog newLog = new CollectableLog(0, collectable.getId(), player.getId(), timeStamp);
        this.collectableLogRepository.add(newLog);
    }

    @Override
    public Optional<Long> findMostRecentTimePlayerFoundCollectable(ECPlayer player, int collectableId) {
        Optional<CollectableLog> log = this.collectableLogRepository.findMostRecentLogForPlayerAndCollectable(player.getId(), collectableId);
        return log.map(CollectableLog::getTimeStamp);
    }

    @Override
    public boolean hasPlayerFoundCollectable(ECPlayer player, int collectableId) {
        return this.findMostRecentTimePlayerFoundCollectable(player, collectableId).isPresent();
    }

    @Override
    public boolean hasPlayerFoundCollectables(ECPlayer player, List<Integer> collectableIdsToCheck) {
        List<CollectableLog> logs = this.collectableLogRepository.findLogsByPlayer(player.getId());
        Set foundCollectableIds = logs.stream().map(CollectableLog::getCollectableId).collect(Collectors.toSet());
        return foundCollectableIds.containsAll(collectableIdsToCheck);
    }

    @Override
    public int getTimesPlayerHasFoundCollectable(ECPlayer player, int collectableId) {
        List<CollectableLog> logs = this.collectableLogRepository.findLogsByPlayerAndCollectable(player.getId(), collectableId);
        return logs.size();
    }

    @Override
    public Optional<Duration> getDurationSincePlayerFoundCollectable(ECPlayer player, int collectableId) {
        Optional<CollectableLog> log = this.collectableLogRepository.findMostRecentLogForPlayerAndCollectable(player.getId(), collectableId);
        return log.map(CollectableLog::getTimeStamp).map(DateUtils::durationSince);
    }

    @Override
    public Optional<Duration> getDurationSinceFirstFound(ECPlayer player, int collectableId) {
        Optional<CollectableLog> log = this.collectableLogRepository.findFirstLogForPlayerAndCollectable(player.getId(), collectableId);
        return log.map(CollectableLog::getTimeStamp).map(DateUtils::durationSince);
    }

    @Override
    public List<Integer> getIdsOfFoundCollectablesForPlayer(ECPlayer player) {
        List<CollectableLog> entries = this.collectableLogRepository.findLogsByPlayer(player.getId());
        return entries.stream().map(CollectableLog::getCollectableId).toList();
    }
}

