/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.compendium;

import com.equestricraft.cdi.Service;
import com.equestricraft.cdi.ServiceInstance;
import com.equestricraft.core.compendium.CompendiumGroup;
import com.equestricraft.core.compendium.CompendiumGroupDetail;
import com.equestricraft.core.compendium.CompendiumProvider;
import com.equestricraft.core.compendium.CompendiumSession;
import com.equestricraft.core.player.ECPlayer;
import java.util.List;

public class CompendiumSessionImpl
implements CompendiumSession {
    @Service
    private ServiceInstance<CompendiumProvider> compendiumProviders;

    @Override
    public List<CompendiumGroup> getGroups() {
        return this.compendiumProviders.stream().map(provider -> new CompendiumGroup(provider.getCompendiumIdentifier(), provider.getCompendiumLabel())).toList();
    }

    @Override
    public CompendiumGroupDetail getItemsInCompendium(ECPlayer player, String identifier) {
        return this.compendiumProviders.stream().filter(p -> p.getCompendiumIdentifier().equals(identifier)).findFirst().map(p -> new CompendiumGroupDetail(identifier, p.getCompendiumLabel(), p.getCompendiumItems(player))).orElseThrow(() -> new IllegalArgumentException(String.format("Invalid compendium group identifier: %s", identifier)));
    }
}

