/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.conformation.check;

import com.equestricraft.common.ConformationCheckType;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.conformation.check.ConformationCheck;
import com.equestricraft.core.conformation.measurement.ConformationMeasurementType;
import com.equestricraft.core.horse.EQHorse;

public class BackConformationCheck
extends ConformationCheck {
    public BackConformationCheck(EQHorse horse) {
        super(horse);
    }

    @Override
    public String getName() {
        return I18n.getLabel("conformation-check.type.back.name");
    }

    @Override
    public String getDescription() {
        return I18n.getLabel("conformation-check.type.back.description");
    }

    @Override
    public double getConformationPercentage() {
        double bodyLength;
        double targetBackLength;
        double backLength = this.getMeasurement(ConformationMeasurementType.BACK);
        if (backLength < (targetBackLength = (bodyLength = this.getMeasurement(ConformationMeasurementType.BODY_LENGTH)) / 3.0)) {
            return backLength / targetBackLength * 100.0;
        }
        if (backLength > targetBackLength) {
            return targetBackLength / backLength * 100.0;
        }
        return 100.0;
    }

    @Override
    ConformationCheckType getType() {
        return ConformationCheckType.BACK;
    }
}

