/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.conformation.check;

import com.equestricraft.common.ConformationCheckType;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.conformation.check.ConformationCheck;
import com.equestricraft.core.conformation.measurement.ConformationMeasurementType;
import com.equestricraft.core.horse.EQHorse;

public class BarrelConformationCheck
extends ConformationCheck {
    public BarrelConformationCheck(EQHorse horse) {
        super(horse);
    }

    @Override
    public String getName() {
        return I18n.getLabel("conformation-check.type.barrel.name");
    }

    @Override
    public String getDescription() {
        return I18n.getLabel("conformation-check.type.barrel.description");
    }

    @Override
    public double getConformationPercentage() {
        double bodyHeight;
        double bodyLength = this.getMeasurement(ConformationMeasurementType.BODY_LENGTH);
        if (bodyLength < (bodyHeight = this.getMeasurement(ConformationMeasurementType.BODY_HEIGHT))) {
            return bodyLength / bodyHeight * 100.0;
        }
        if (bodyLength > bodyHeight) {
            return bodyHeight / bodyLength * 100.0;
        }
        return 100.0;
    }

    @Override
    boolean affectsSpeed() {
        return true;
    }

    @Override
    ConformationCheckType getType() {
        return ConformationCheckType.BARREL;
    }
}

